{   $Id: stack.pas 6975 2005-08-20 22:34:53Z stell $

    OpenXP generic stack unit

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{$I xpdefine.inc }

unit stack;

interface

uses
  xpglobal;

procedure spush(var x; size:word);
procedure spop(var x);

implementation

type  stp = ^ste;
      ste = record
              inhalt : pointer;
              groesse: word;
              adr    : pointer;    { fr Integritts-Test }
              next   : stp;
              last   : stp;
            end;

const tail : stp = nil;


{$IFDEF Debug }
procedure error(txt:string);
begin
  writeln('<Stack> ',txt);
  halt(1);
end;
{$ENDIF }


procedure spush(var x; size:word);
var p : stp;
begin
  new(p);
  if tail=nil then begin
    tail:=p;
    p^.next:=nil; p^.last:=nil;
    end
  else begin
    p^.last:=tail;
    p^.next:=nil;
    tail:=p;
    end;
  getmem(p^.inhalt,size);
  Move(x,p^.inhalt^,size);
  p^.groesse:=size;
  p^.adr:=@x
end;


procedure spop(var x);
var p : stp;
begin
{$IFDEF Debug }
  if tail=nil then
    error('Underflow');
  if @x<>tail^.adr then
    error('var mismatch');
{$ENDIF }
  Move(tail^.inhalt^,x,tail^.groesse);
  freemem(tail^.inhalt,tail^.groesse);
  p:=tail;
  tail:=tail^.last;
  dispose(p);
end;


end.
