{ $Id: xp3o.inc 7130 2005-10-26 09:04:41Z mkaemmerer $

   Copyright (C) 2000-2002 OpenXP team (www.openxp.de)
   Copyright (C) 1991-1999 Peter Mandrella (www.crosspoint.de)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

procedure readpuffer;
var x,y   : Integer;
    s     : string;
    brk   : boolean;
    ed,pb : boolean;
    ebest : boolean;
    read  : boolean;
    useclip: boolean;
begin
  s:=WildCard;
  useclip:=true;
  if ReadFilename(getres2(330,1),s,true,useclip) then   { 'Puffer einlesen' }
    if not FileExists(s) then
      rfehler(304)   { 'Datei nicht vorhanden!' }
    else if pos(UpperCase(AblagenFile),UpperCase(s))=1 then
      rfehler(305)   { 'Interne Ablage - bitte erst umbenennen!' }
    else begin
      dialog(46,6,fitpath(s,38),x,y);
      ed:=false; pb:=true;
      ebest:=false; read:=false;
      maddbool(3,2,getres2(330,2),ed); mhnr(101);   { 'Empfangsdatum = Erstellungsdatum' }
      maddbool(3,3,getres2(330,3),pb);     { 'Server aus Pfad bernehmen' }
      maddbool(3,4,getres2(330,4),ebest);  { 'Empfangsbesttigungen versenden' }
      maddbool(3,5,getres2(330,5),read);   { 'Nachrichten als "gelesen" markieren' }
      readmask(brk);
      closemask;
      closebox;
      if not brk then
        if puffereinlesen(s,iifs(pb,'',DefaultBox),ed,false,ebest,
                          iif(read,pe_gelesen,0)) then
          signal;
      if useclip then _era(s);
      end;
  freeres;
end;


{ Pollbox='' -> Pollbox wird aus Pfad bernommen, falls vor-  }
{               handen, sonst aus DefaultBox                  }
{ Replace-ED :  Empfangsdatum durch Erstellungsdatum ersetzen }

function  PufferEinlesen(puffer:string; pollbox:string; replace_ed,
                         sendbuf,ebest:boolean; pflags:word):boolean;

const
  bufsize  = 262144; { 256kb Puffer unter 32 Bit ist ok }

type
  PRefItem = ^TRefItem;
  TRefItem = record
    MsgPos, MsgId, MsgRef, Datum: Integer;
  end;

var x,y      : Integer;
    f, pfile     : file;
    fm: Byte;
    RefList    : TList;
    padr,size: longint;
    ablage   : byte;
    abadd    : byte;
    p        : charrp;
    adr,fs,l : longint;
    hdp      : THeader;
    i        : integer;
    hdsize   : longint;
    rr       : Integer;
    dat      : string;
    name     : string;
    pb       : string;
    _brett   : string;
    mapsname : string;
    seekbr   : string;
    msgid2   : string;    { gekrzte MsgID (FormMsgid) fr mbase }
    msgid3   : string;    { generierte MsgID fuer Nachrichten ohne }
    amvertreter,
    pmvertreter : string;
    sysbetreff  : string;  { Betreff von Changesys/getsys }
    orgempf  : string;
    tobrett  : boolean;
    typ1     : char;
    ok       : boolean;
    adrbuch  : byte;
    flags    : longint;
    atp      : byte;
    grnr     : longint;
    ld       : longint;
    uflags   : byte;
    aufnehmen: boolean;
    diff     : integer;
    d        : DB;
    haltezeit: integer16;
    MsgCount : longint;
    brettlog,
    userlog  : text;
    _datum   : longint;
    check    : boolean;
    p0       : byte;
    zconnect : boolean;
    pm       : boolean;
    mnt      : longint;       { Netztyp-Feld fr mbase }
    today    : longint;
    empfnr   : integer;
    junk     : boolean;
    msgsent  : boolean;
    forcepfadbox: boolean;
    IsGelesen   : boolean;
    cmessagefile:text;         { Datei fr Controlmessages (Cancels/Supersedes) }
    num_cmessages : integer;   { Anzahl Controlmessages (Cancels/Supersedes) }
    mbflags  : longint;
    mstr     : string;          { Message-Text }
    sp       : scrptr;
    ReplaceOwnHoldFlag: byte;
    MsgIdsRead: TStringList;
    dummy    : integer;
    cust_header : custheadstr;
    BrettKommentar : string;

  function puffer_ok:boolean;
  var ok : boolean; lastsubj,lastmid: string;
  begin
    moff;
    mstr:=getres(331);
    FWrt(x+2,y+2,mstr);    { 'Puffer berprfen...' }
    mon;
    MsgCount:=0; adr:=0; lastsubj:=''; lastmid:='';
    repeat
      inc(MsgCount);
      if MsgCount mod 10=0 then
      begin
        moff;
        FWrt(x+3+length(mstr),y+2, StrS(MsgCount));
        mon;
      end;
      seek(f,adr);
      makeheader(zconnect,f,0,hdsize,hdp,ok,true, true);
      if ok then begin
        inc(adr,hdsize+hdp.groesse);
        lastsubj:=hdp.betreff; lastmid:=hdp.msgid;
        end;
    until not ok or (adr>=fs-3);     { Der Puffer kann maximal 3 zustzliche }
    if (MsgCount>0) then begin
      moff;
      FWrt(x+3+length(mstr),y+2,strs(MsgCount));
      mon;
    end;
    result:=ok and (adr<=fs+8);
    if not result then Debug.DebugLog('xp3o','Last correct message: '+lastsubj+', '+lastmid+', filepos now '+inttostr(adr),DLError);
    diff:=min(maxint,max(0,fs-adr));
  end;

{
  procedure writemsg;
  var size : longint;
      rr   : word;
  begin
    dbWriteN(mbase,mb_ablage,ablage);
    dbWriteN(mbase,mb_adresse,padr);
    size:=hdp.groesse+hdsize;
    dbWriteN(mbase,mb_msgsize,size);
    blockwrite(pfile,p^,min(readfirst,hdsize+hdp.groesse));
    dec(size,readfirst);
    if size>0 then begin
      repeat
        blockread(f,p^,min(bufsize,size),rr);
        blockwrite(pfile,p^,rr);
        dec(size,rr);
      until size=0;
    end;
    inc(padr,hdp.groesse+hdsize);
  end;
}

  function dummyid(inr: integer): string;
  var t,m,j   : smallword;
      h,mm,s,ss: smallword;
      dat     : integer;
      count   : integer;
      rand    : integer;
      csum    : integer;
  begin
    decodedate(now,j,m,t);
    decodetime(now,h,mm,s,ss);
    dat:=(t-1)+(m-1)*32+(j mod 165)*32*12;

    count:=Integer(inr and $ffff);
    rand:=random($1000);
    csum:=crc16strXP(hdp.Absender);

    Result := FormMsgID(b30(crc32Str(hdp.FirstEmpfaenger))+
      b30(longint(dat) shl 14+count shr 2)+
      b30(longint(count and 3) shl 28+longint(rand) shl 16 +csum));
  end;

  function pollbox_str(zconnect,user:boolean):string;
  begin
    if not user and (amvertreter<>'') then
      pollbox_str:=amvertreter
    else if user and (pmvertreter<>'') then
      pollbox_str:=pmvertreter
    else if not forcepfadbox and (pollbox<>'') then
      pollbox_str:=pollbox
    else if trim(hdp.pfad)='' then
      pollbox_str:=DefaultBox
    else
      pollbox_str:=pfadbox(zconnect,hdp.pfad);
  end;

  function adrok(const s:string):boolean;
  begin
    adrok:=(useraufnahme=0) or
           ((useraufnahme=1) and (pm or ((cPos('%',s)=0) and (cPos(':',s)=0)))) or
           ((useraufnahme=3) and pm);
  end;

  function isl(const s:string):boolean;
  begin
    isl:=LeftStr(hdp.betreff,length(s))=s;
  end;

  function LeftAbsender(const s:string):boolean;
  begin
    LeftAbsender:=(LeftStr(LowerCase(hdp.absender),length(s)+1+length(pollbox))=LowerCase(s+'@'+pollbox));
  end;

  procedure bearbeiteMsg(var id,abs,sender:string; cancel:boolean);
  var crc  : longint;
      hdp2 : THeader;
      hds  : longint;
      rec  : longint;
      mrec : longint;

    procedure DelMsg;
    var b : byte;
    begin
      b:=1;  dbWriteN(mbase,mb_gelesen,b);
      b:=2;  dbWriteN(mbase,mb_halteflags,b);   { gelscht }
      dbReadN(mbase,mb_unversandt,b);
      b:=b or 128;                              { gecancelt }
      dbWriteN(mbase,mb_unversandt,b);
    end;

    { Fr die Bearbeitung von Cancel-Nachrichten wurde u.a. der folgende
      Abschnitt aus RFC 1036 zu Grunde gelegt:

      "Only the author of the message or the local news administrator is
       allowed to send this message.  The verified sender of a message is
       the "Sender" line, or if no "Sender" line is present, the "From"
       line.  The verified sender of the cancel message must be the same as
       either the "Sender" or "From" field of the original message.  A
       verified sender in the cancel message is allowed to match an
       unverified "From" in the original message." }

    function okay:boolean;
    begin
      if sender<>'' then
        { 11.09.05 HJT: UUZ versorgt jetzt aus 'Sender' den WAB }
        { damit muessen wir hier auch gegen den WAB pruefen     }
        { result:=((hdp2.absender=sender) or (hdp2.cust1=sender)) and (hdp2.msgid=id) }
        result:=((hdp2.absender=sender) or (hdp2.wab=sender)) and (hdp2.msgid=id)
      else
        result:=(hdp2.absender=abs) or (hdp2.cust1=abs) and (hdp2.msgid=id);
    end;

  begin
    mrec:=0;
    TrimFirstChar(id, '<');
    TrimLastChar(id, '>');
    if cpos('@',id)=0 then exit;
    crc:=MsgidIndex(id);
    hdp2 := THeader.Create;
    if cancel then mrec:=dbRecno(mbase); { Position der Cancel-Mail merken }
    dbSeek(bezbase,beiMsgId,dbLongStr(crc));
    if dbFound then
      while (not dbEOF(bezbase)) and (dbReadIntN(bezbase,bezb_msgid)=crc) do begin
        repeat;
          hdp2.msgid:='';
          rec:=dbReadIntN(bezbase,bezb_msgpos);
          if not dbDeleted(mbase,rec) then begin   { sicher ist sicher.. }
            dbGo(mbase,rec);
            Readheader(hdp2,hds,false);
          end;
          dbNext(bezbase);
        until (hdp2.msgid=id) or dbEOF(bezbase) or (dbReadIntN(bezbase,bezb_msgid)<>crc);
        { HJT 10.09.05, die ausloesende ERSETZT-Nachricht nicht auf loeschen setzen }
        { if okay then DelMsg; } { zu lschende/zu ersetzende Nachricht lschen }
        if okay and (cancel or (hdp2.msgid <> hdp2.ersetzt)) then DelMsg; { zu lschende/zu ersetzende Nachricht lschen }
      end;
    Hdp2.Free;
    if cancel then begin
      dbGo(mbase,mrec);
      DelMsg;   { Cancel-Nachricht auf 'gelesen' / 'lschen' }
    end;
  end;

  procedure bearbeite_cancels_supersedes;
  var
      id : string;
      abs: string;
      str: string;
      sender :custheadstr;
      rec: longint;
      n  : longint;
      l  : integer;
  begin
    Debug.DebugLog('xp3o','start bearbeite_cancels_supersedes',DLTrace);
    reset(cmessagefile);
    n:=0;
    FWrt(x+2,y+6,getres(341)); { 'Bearbeite Steuernachrichten...' }
    l:=Length(getres(341));
    while not eof(cmessagefile) do begin
      Inc(n);
      FWrt(x+2+l,y+6,strs((n * 100) div num_cmessages)+'%');
      readln(cmessagefile,str);
      if str='cancel' then begin
        readln(cmessagefile,rec);
        dbGo(mbase,rec);
        readln(cmessagefile,id);
        readln(cmessagefile,abs);
        readln(cmessagefile,sender);
        bearbeiteMsg(id,abs,sender,true)
      end else begin
        readln(cmessagefile,id);
        readln(cmessagefile,abs);
        readln(cmessagefile,sender);
        bearbeiteMsg(id,abs,sender,false);
      end;
    end;
    close(cmessagefile);
    FWrt(x+2+l,y+6,getres2(324,7)); { 'fertig.' }
  end;

  function IsCancelMsg:boolean;
  begin
    with hdp do
      IsCancelMsg:=(attrib and attrControl<>0) and
                   (LowerCase(LeftStr(control,7))='cancel ');
  end;

  function isSupersedesMsg:boolean;
  begin
    isSupersedesMsg:=(hdp.ersetzt<>'');
  end;

  function IsSupportCfg:boolean;

    function NameOk:boolean;
    begin
      NameOk:=stricmp(hdp.realname,inout.pm) or
              (pos(LowerCase(inout.pm),LowerCase(hdp.absender))>0);
    end;

    function XPctlOk:boolean;
    var sum : longint;
        i   : integer;
    begin
      with hdp do begin
        sum:=0;
        for i:=1 to length(datum) do
          inc(sum,ord(datum[i])*7);
        for i:=1 to length(msgid) do
          inc(sum,ord(msgid[i])*3);
        XpCtlOk:=(sum=XpointCtl div 1000);
        end;
    end;

  begin
    with hdp do
      IsSupportCfg:=
        (ntXPctl(netztyp) and NameOk and XPctlOk) or
        ((netztyp=nt_Maus) and (absender=inout.pm+'@LU') and
         (LeftStr(betreff,11)=SupportCfg));
  end;

  procedure TestControlMessage;
  var box    : string[20];
      fstype : byte;
  begin
    automessaging:=true;
    with hdp do begin
      if aufnehmen and
        ( ((LeftStr(UpperCase(betreff),7)='BRETTER') or
           (pos('your list',LowerCase(betreff))>0))
         and
         stricmp(LeftStr(absender,length(mapsname)),mapsname) and
         (FirstChar(FirstEmpfaenger)='1') )
      or
         ((LeftStr(absender,7)='SYSTEM@') and
          ((LeftStr(UpperCase(betreff),11)='NETZBRETTER') or  { QuickMail }
           (UpperCase(betreff)='BESTELLBARE BRETTER')  or  { G & S     }
           (pos('BRETTLISTE',UpperCase(betreff))>0)))      { ZQWK }
          then begin
        MapsReadList;
        end;

      if (LeftStr(UpperCase(betreff),6)='FILES.') and (cpos('@',absender)>0) and
         (typ='T') then
      begin
        box:=copy(absender,cpos('@',absender)+1,20);
        if cpos('.',box)>0 then begin
          box:=LeftStr(box,cpos('.',box)-1);
          if IsServer(box,fstype) and (fstype<>3) then begin
            FS_Readlist(true);
            end;
          end;
        end;

      if (FirstChar(FirstEmpfaenger)='1') { PM } and empfbest and ebest and
         (((attrib and attrReqEB<>0) and (attrib and attrIsEB=0)) or
          ((empfbkennung<>'') and (isl(empfbkennung) or
            isl(QPC_ID+empfbkennung) or isl(DES_ID+empfbkennung)))) then
      begin
        empfang_bestaetigen(pollbox);
        end;

      if (sysbetreff<>'') and (FirstChar(FirstEmpfaenger)='1') and (LowerCase(betreff)=sysbetreff) and
         (LeftAbsender('changesys') or LeftAbsender('news') or
          LeftAbsender('postmaster') or LeftAbsender('root')) then
      begin
        GetSysfile;
        end;

      if UsePGP and (FirstChar(FirstEmpfaenger)='1') { PM } and
         (pgpflags and fPGP_request<>0) and ebest then begin
        if pollbox<>'' then
          xpsendmessage.forcebox:=pollbox
        else
          xpsendmessage.forcebox:=pfadbox(true,pfad);
        xpsendmessage._bezug:=msgid;
        xpsendmessage._beznet:=netztyp;
        PGP_SendKey(iifs(pgp_uid='',absender,pgp_uid));
        xpsendmessage.forcebox:='';
        end;

      if isSupersedesMsg and (not ignoreSupCancel) then begin
        writeln(cmessagefile,'supersedes');
        writeln(cmessagefile,ersetzt);
        writeln(cmessagefile,absender);
        if cust1<>'' then
          writeln(cmessagefile,cust1)
        else
          writeln(cmessagefile,wab);
        inc(num_cmessages);
      end;

      if IsCancelMsg and (not ignoreSupCancel) then begin
        writeln(cmessagefile,'cancel');
        writeln(cmessagefile,dbRecno(mbase));
        writeln(cmessagefile,trim(mid(control,8)));
        writeln(cmessagefile,absender);
        if cust1<>'' then
          writeln(cmessagefile,cust1)
        else
          writeln(cmessagefile,wab);
        inc(num_cmessages);
      end;

      if IsSupportCFG then
        XRead(SupportCfg,false);
      end;
    automessaging:=false;
  end;

  function logstr(s:string):string;
  begin
    logstr:=LeftStr(date,6)+RightStr(date,2)+' '+LeftStr(time,5)+' '+s;
  end;

  procedure pmCryptDecode;
  var passwd,s : string;
      size     : integer;
      codierer : byte;
      f,f2     : file;
      tmp      : string;
      uncfile  : string;
      uvs      : byte;
      hdp2     : THeader;
      hds2     : longint;
      ok       : boolean;
      orgsize  : longint;
      orgempf  : AdrStr;
      sp       : scrptr;
      hdp2typ  : char;
  begin
    size:=0;
    dbSeek(ubase,uiName,UpperCase(hdp.absender));
    uflags := 0;
    if not dbFound then exit;
    passwd:= dbReadXStr(ubase,'passwort',size);
    dbReadN(ubase,ub_codierer,codierer);
    if (passwd='') or (codierer<3) or (codierer>2+maxpmc) or
      (TempFree<2*dbReadInt(mbase,'msgsize')) then exit;
    hdp2 := THeader.Create;
    ReadHeader(hdp2,hds2,true);
    assign(f,temppath+cryptedfile);
    rewrite(f,1);
    XreadF(dbReadInt(mbase,'msgsize')-dbReadInt(mbase,'groesse'),f);
    close(f);
    uncfile:=temppath+uncryptedfile;
    s:=pmcrypt[codierer-2].decode;
    rps(s,'$KEY',passwd);
    rps(s,'$INFILE',temppath+cryptedfile);
    rps(s,'$OUTFILE',uncfile);
    rps(s,'$USER',hdp.absender);
    SafeDeleteFile(uncfile);
    savecursor;
    sichern(sp);
    shell(s,600,3);                     { Nachricht decodieren }
    if existf(f) then erase(f);       { codierte Msg lschen, falls noch da }
    if not FileExists(uncfile) then
      trfehler(306,5)         { 'Fehler beim Decodieren' }
    else begin
      assign(f,uncfile);
      reset(f,1);
      makeheader(false,f,0,hds2,hdp2,ok,false, true);
      close(f);
      if not ok then
        trfehler(306,5)       { 'Fehler beim Decodieren' }
      else begin
        reset(f,1);   { uncfile }
        hdp.betreff:=hdp2.betreff;
        hdp.typ:=hdp2.typ;
        orgsize:=hdp.groesse;     hdp.groesse:=filesize(f)-hds2;  { = hdp2^.groesse }
        orgempf:=hdp.FirstEmpfaenger;  hdp.empfaenger:=hdp2.empfaenger;
        tmp:=TempS(hdp.groesse+2048);
        assign(f2,tmp);
        rewrite(f2,1);
        ClearPGPflags(hdp);
        WriteHeader(hdp,f2);             { neuer Header }
        seek(f,hds2);
        fmove(f,f2);                     { + decodierter Text }
        close(f); close(f2);
        erase(f);   { uncfile }
        Xwrite(tmp);
        wrkilled;
        _era(tmp);
        dbWriteNStr(mbase,mb_betreff,hdp2.betreff);

        hdp2typ := hdp2.typChar;
        dbWriteN(mbase,mb_typ,hdp2typ);
        
        dbWriteN(mbase,mb_groesse,hdp.groesse);
        dbReadN(mbase,mb_unversandt,uvs);
        uvs:=uvs or 4;                        { "c"-Flag }
        dbWriteN(mbase,mb_unversandt,uvs);
        hdp.groesse:=orgsize;
        hdp.FirstEmpfaenger:=orgempf;
        end;
      end;
    holen(sp);
    restcursor;
    Hdp2.Free;
  end;

  procedure DecPGP;
  var s : string[AdrLen];
      sp: scrptr;
  begin
    s:=hdp.Firstempfaenger;
    hdp.Firstempfaenger:=orgempf;
    savecursor;
    sichern(sp);
    LogPGP(getreps2(3002,2,hdp.absender));  { 'decodiere Nachricht von %s' }
    PGP_DecodeMessage(hdp,false);
    holen(sp);
    restcursor;
    hdp.Firstempfaenger:=s;
  end;

  procedure Bezugsverkettung;
  var
    RefItem: PRefItem;
    i: Integer;
  begin
    Debug.DebugLog('xp3o','start Bezugsverkettung',DLInform);

    moff;
    mstr:= getres(332);
    FWrt(x+2,y+5,mstr); { 'Bezugsverkettung...' }
    FWrt(x+3+length(mstr),y+5,'0%');
    mon;

    dbStopHU(bezbase);
    try
      for i := 0 to RefList.count -1 do
      begin
        RefItem := RefList[i];
        xp1o.AddNewBezug(RefItem.MsgPos, RefItem.MsgId, RefItem.MsgRef, RefItem.Datum);

        if ((i mod 10)=0) then
        begin
          moff;
          FWrt(x+3+length(mstr),y+5,StrS(i*100 div fs)+'%');
          mon;
        end;
      end;
    finally
      dbRestartHU(bezbase);
      dbFlush(bezbase);
      Debug.DebugLog('xp3o','end Bezugsverkettung',DLTrace);
    end;
    Wrt(x+3+length(mstr),y+5,getres2(324,7)); { 'fertig.' }
  end;

  procedure AddNewBezug(MsgNr: Longint; const MsgId, RefId: string; datum: longint);
  var
    RefItem: PRefItem;
    zwiref: string; { HJT 14.09.05 }
  begin
    if MsgId='' then exit;
    New(RefItem);
    RefItem^.MsgPos := MsgNr;
    RefItem^.MsgId := MsgidIndex(msgid);
    if RefId='' then
      RefItem^.MsgRef := 0
      { HJT 14.09.05: Bezug normalisieren start }
    { else }
      { RefItem^.MsgRef := MsgidIndex(refid); }
     else begin
       zwiref:=NormalizeBezug(refid);
       if length(zwiref) = 0 then
         RefItem^.MsgRef := 0
       else
         RefItem^.MsgRef:=MsgidIndex(zwiref);
      end;
      { HJT 14.09.05: end }
    RefItem^.Datum := Datum;
    RefList.Add(RefItem);
  end;

  function IsOwnDomain(dom:string):boolean;
  var
    Index: Integer;
  begin
    if cpos('@',dom)=0 then
      IsOwnDomain:=false
    else
    begin
      delete(dom,1,cpos('@',dom));
      IsOwnDomain := DomainList.Find(LowerCase(dom), Index);
    end;
  end;

  { returns true if *own* message is going to be replaced.
    Used for ReplaceOwn and ReplaceDupes. }
  function KillSameMsgId: boolean;
  var
    MsgPos: Integer;
  begin
    result:= false;
    dbSeek(bezbase,beiMsgID,dbLongStr(MsgidIndex(Hdp.msgid)));
    if dbFound and not dbDeleted(bezbase, dbRecNo(bezbase)) then
    begin
      // message with same msgid found in db
      msgpos := dbReadIntN(bezbase,bezb_msgpos);
      if not dbDeleted(mbase, msgpos) then
      begin
        flags := 0;
        dbGo(mbase, msgpos);
        if not dbBOF(mBase) and not dbEOF(mbase) then
        begin
          dbReadN(mbase,mb_flags,flags); { get message flags }
          if (flags and 256 <> 0) or
            (boxpar^.ReplaceDupes) then
          begin
            debug.debuglog('xp3o','dupe (already in msgbase)',dltrace);
            dbReadN(mbase,mb_halteflags, ReplaceOwnHoldFlag);
            wrkilled; { Ablage auf jeden Fall reorganisieren }
            DelBezug;
            dbDelete(mbase);
            result:= (flags and 256 <> 0);
          end;
        end else
          debug.debuglog('xp3o','Error in KillSameMsgId: dbGo to bad message',dltrace);
      end;
    end;
  end;

var
  OwnMessageReplaced: Boolean;
  s: String;
  nt: Byte;
  RefItem: PRefItem;
  f_str: TPASCALFileStream;     // current message buffer as a TStream (nil until first use)
  data:  TPartialStream;        // temporary: current message
  spam:  TSpamicityCalculator;  // spamicity calculator (nil until first use)
  spam_ok: boolean;             // whether spamicity has been calculated for current message
  is_spam: boolean;             // whether current message is spam
  is_ham:  boolean;
 begin
  Debug.DebugLog('xp3o','sorting in messages',DLInform);
  inmsgs:=0; ReplaceOwnHoldFlag:=255; puffereinlesen:=false;
  MsgIdsRead:=TStringlist.Create; MsgIdsRead.Sorted:=true;
  RefList := TList.Create;
  forcepfadbox:=(pflags and pe_ForcePfadbox<>0);
  zconnect:=ZC_puffer(puffer);
  if (zconnect) then
    msgbox(47,10,getres(333),x,y)        { 'Puffer einlesen' }
  else
    msgbox(47,11,getres(333),x,y);
  attrtxt(col.colmbox);
  fm := FileMode;
  assign(f,puffer);
  FileMode := fmOpenRead + fmShareDenyWrite;
  reset(f,1);
  FileMode := fm;
  fs:=filesize(f);
  if fs<16 then begin
    close(f);
    moff;
    Debug.DebugLog('xp3o','empty buffer',DLInform);
    rmessage(334);      { 'leerer Puffer' }
    mon;
    wkey(1,false);
    closebox;
    closebox;
    freeres;
    puffereinlesen:=true;
    exit;
    end;
  check:=(fs*1.3<diskfree(0));

  getmem(p,bufsize);
  hdp := THeader.Create;
  if check and puffer_ok then begin
    abadd:=iif(zconnect,10,0);
    l:=ablsize[1+abadd]; ablage:=1+abadd;   { 0/10 = PM-Ablage }
    for i:=2+abadd to 9+abadd do
      if ablsize[i]<l then begin
        ablage:=i; l:=ablsize[i];
        end;

    assign(brettlog,logpath+brettLogfile);
    if existf(brettlog) then append(brettlog)
    else rewrite(brettlog);
    assign(userlog,logpath+userLogfile);
    if existf(userlog) then append(userlog)
    else rewrite(userlog);

    if pollbox='' then begin
      mapsname:='MAPS'; amvertreter:=''; pmvertreter:='';
      sysbetreff:='';
      end
    else begin
      dbOpen(d,BoxenFile,1);
      dbSeek(d,boiName,UpperCase(pollbox));
      if not dbFound then begin
        mapsname:=''; amvertreter:=''; pmvertreter:='';
        sysbetreff:='';
        end
      else begin
        mapsname:= dbReadStr(d,'nameomaps');
        AMvertreter:= dbReadStr(d,'AVertreter');
        PMvertreter:= dbReadStr(d,'PVertreter');
        dbSeek(d,boiName,UpperCase(amvertreter));
        if not dbFound then amvertreter:='';
        dbSeek(d,boiName,UpperCase(pmvertreter));
        if not dbFound then pmvertreter:='';
        dbSeek(d,boiname,UpperCase(pollbox));
        nt := dbReadInt(d,'netztyp');
        if nt in netsRFC then
        begin
          ReadBoxPar(nt, pollbox);
          sysbetreff:=LowerCase(boxpar^.chsysbetr);
          end;
        end;
      dbClose(d);
      end;

    moff;
    Debug.DebugLog('xp3o','appending buffer to mbuffer',DLInform);
    Wrt(x+2,y+3,getres(335));           { 'Puffer kopieren...' }
    mon;
    assign(pfile,aFile(ablage));        { Puffer in die kleinste }
    if existf(pfile) then begin         { Ablage kopieren ..     }
      reset(pfile,1);
      padr:=filesize(pfile);
      seek(pfile,padr);
      end
    else begin
      rewrite(pfile,1);
      padr:=0;
      end;
    seek(f,0);
    size:=filesize(f)-diff;
    repeat
      blockread(f,p^,bufsize,rr);
      blockwrite(pfile,p^,rr);
      dec(size,rr);
    until eof(f);
    close(pfile);
    
    moff;
    Wrt2(' '+getres2(324,7));           { fertig }
    mstr:= getres2(330,6);              { Importiere Nachrichten }
    FWrt(x+2,y+4,mstr+' 0%');
    mon;

    Debug.DebugLog('xp3o','adding messages to db index',DLInform);
    seek(f,0);

    assign(cmessagefile,TempS(msgcount*40+2048));
    rewrite(cmessagefile);
    num_cmessages:=0;

    adr:=0;
    dat:=Zdate;
    today:=ixDat(dat);
    dbStopHU(mbase);

    cust_header:=mheadercustom[1];
    mheadercustom[1]:='U-Sender';  { 'U-Sender'-Header erkennen }

    f_str := nil;
    spam := nil;

    repeat
      empfnr:=1;
      junk:=false;
      msgsent:=false;       { true -> Nachricht wurde in mind. einem Brett gespeichert
                                      oder soll weggeworfen werden
                              false -> Nachricht muss in />>Junk gespeichert werden }

      spam_ok := false;
      is_spam := false;
      is_ham  := false;

      msgid3  := '';

      repeat       { Cross-Postings bearbeiten }
        seek(f,adr);
        Debug.DebugLog('xp3o','recipient "'+orgempf+'", subject "'+hdp.betreff+'", msgid "'+hdp.msgid+'"',DLDebug);
        hdp.clear;
        makeheader(zconnect,f,empfnr,hdsize,hdp,ok,true, true);
        orgempf:=hdp.FirstEmpfaenger;
        BrettKommentar := '';

        { Schalter maildelxpost beachten }
        if (hdp.Empfaenger.Count > maxcrosspost)
        and ((cpos('@',hdp.FirstEmpfaenger)=0) or maildelxpost) then begin
          empfnr:=hdp.Empfaenger.Count +1;                { Crossposting-Filter }
          continue;
          end;

(*        if (CPos('@', hdp.FirstEmpfaenger) > 0) and (not spam_ok) then
        begin
          if not assigned(spam) then
            spam := TSpamicityCalculator.Create;
          if not assigned(f_str) then
            f_str := TPASCALFileStream.Create(f);

          data := TPartialStream.Create(adr,adr+hdsize+hdp.groesse);
          data.OtherStream := f_str;          // use message buffer
          data.DestroyOtherStream := false;   // but don't kill it
          data.Seek(0,soFromBeginning);
          spam.CalculateMessageSpamicity(data);
          data.Free;

          is_spam := spam.IsSpam;
          is_ham  := spam.IsHam;
          spam_ok := true;

          if is_spam then
          begin
            hdp.Empfaenger.Clear;
            hdp.Empfaenger.Add('/Spam'); // Unterscheidung von der Pseudo-Newsgroup junk
            BrettKommentar := 'SPAM, SPAM, wonderful SPAM!' // nicht uebersetzen (Zitat aus Monty Phyton).
          end;
        end;  *)



        if junk then
        begin
          hdp.Empfaenger.Clear;
          hdp.Empfaenger.Add('/Nix'); // Unterscheidung von der Pseudo-Newsgroup junk
        end;
        if grosswandeln and not zconnect then
        begin
          hdp.Absender := UpperCase(hdp.absender);
          hdp.FirstEmpfaenger := UpperCase(hdp.Firstempfaenger);
        end;
        pm:=false;

        with hdp do
        begin
          if replace_ed then dat:=datum;
          _datum:=ixdat(dat);
          if replace_ed and smdl(today,_datum) then begin
            dat:=zdate;
            _datum:=today;
            end;
          tobrett:=archive or (copy(FirstEmpfaenger,1,TO_len)=TO_ID);
          atp:=cPos('@',FirstEmpfaenger);
          if sendbuf then begin   { pollbox <> '' !  }
            if (FirstChar(FirstEmpfaenger)<>'/') and (cpos('@',Firstempfaenger)=0) then
              Firstempfaenger:=Firstempfaenger+'@'+pollbox+'.ZER';
            if cpos('@',Firstempfaenger)>0 then
              if tobrett then
                Firstempfaenger:='U'+mid(Firstempfaenger,iif(archive,1,length(TO_ID)+1))
              else begin
                Firstempfaenger:='U'+Firstempfaenger;
                //tobrett:=true;
                end
            else
              FirstEmpfaenger:='A'+Firstempfaenger;
            end
          else     { not sendbuf }
            if tobrett then
              if (copy(Firstempfaenger,1,9)<>'/'#0#0#8#8'TO:/') or (atp>0) then
                Firstempfaenger:='U'+copy(Firstempfaenger,iif(archive,1,9),79)
              else
              begin
                s := FirstEmpfaenger;
                while (length(s) >= 10) and (s[10]=#255) do  { wg. #255#255'Netzanruf' }
                  delete(s,10,1);
                FirstEmpfaenger:='$/'+Mid(s,10);
              end
            else
              if (Length(FirstEmpfaenger) >= 2) and (FirstEmpfaenger[2]='') then
                Firstempfaenger:='$'+FirstEmpfaenger
              else
                if (atp=0) and (FirstChar(FirstEmpfaenger) = '/') then
                  FirstEmpfaenger:='A'+FirstEmpfaenger
                else begin
                  if atp=0 then FirstEmpfaenger:='1/'+FirstEmpfaenger
                  else
                    if UserBoxname then
                      Firstempfaenger:='1/'+LeftStr(Firstempfaenger,atp-1)+'/'+mid(Firstempfaenger,atp+1)
                    else
                      Firstempfaenger:='1/'+LeftStr(Firstempfaenger,atp-1);
                  pm:=true;
                  end;

          if (ForceRecipient<>'') and (not is_spam)  then Firstempfaenger:= ForceRecipient;

          multi2; initscs;

          Debug.DebugLog('xp3o.inc', 'point multi2', DLDebug);

          truncstr(absender,eAdrLen);  { dbSeek laeuft sonst ins Leere }
          dbSeek(ubase,uiName,UpperCase(absender));
          // do not add users with names longer 80 char, our database is not large enough
          uflags:=0; { HJT 18.09.05 sonst wird eine zufaellige Prio in flags(MSGS.DB1) eingetragen }
          if not dbFound then
          begin          { neuen User anlegen }
            if adrok(absender) then
            begin
              { mwrt(29,wherey,forms(absender,22)); }
              AddNewUser(Absender, pollbox_str(zconnect,true));
              writeln(userlog,logstr(absender));
            end;        { Netzunabhngige Useraufnahme }
            aufnehmen:=true;
          end
          else
            if FirstChar(FirstEmpfaenger)<>'A' then
              aufnehmen:=true
                         {((pos('@mips.pfalz.de',absender)=0) and
                          (pos('news@pythia.lunetix.de',absender)=0) and
                          (pos('news@dfki.uni-sb.de',absender)=0)) }
            else begin
              dbReadN(ubase,ub_userflags,uflags);
              aufnehmen:=odd(uflags); // Filter AMs (Twit filter)
              if not aufnehmen then
                // AM is filtered, don''t put it in /Junk
                msgsent:=true;
              end;

          if FirstChar(Firstempfaenger)<>'U' then begin
            // AM
            dbSeek(bbase,biBrett,UpperCase(Firstempfaenger));
            if not dbFound then
            begin
              // AM for a group not yet existing
              if (Empfaenger.Count>1) or (attrib and AttrControl<>0) then begin
                debug.debuglog('xp3o','crossposting or cancel msg',dltrace);
                aufnehmen:=false;
                end
              else if aufnehmen then begin
                // create new group
                if FirstChar(Firstempfaenger)<>'A' then grnr:=IntGruppe
                else begin
                  seekbr:=Firstempfaenger;
                  p0:=posn('/',seekbr,3);
                  if p0>0 then begin
                    seekbr:=LeftStr(seekbr,p0-1);
                    if dbEOF(bbase) or
                       (LeftStr(dbReadStrN(bbase,bb_brettname),length(seekbr))<>seekbr) then
                      dbSeek(bbase,biBrett,UpperCase(seekbr));
                    end;
                  if dbEOF(bbase) then dbGoEnd(bbase);
                  if dbEOF(bbase) then grnr:=NetzGruppe
                  else dbReadN(bbase,bb_gruppe,grnr);
                  if grnr=IntGruppe then grnr:=NetzGruppe;
                  end;
                if FirstChar(Firstempfaenger)='1' then
                  haltezeit:=0
                else 
                begin
                  dbOpen(d,GruppenFile,1);
                  dbSeek(d,giIntnr,dbLongStr(grnr));
                  if not dbFound then haltezeit:=stdhaltezeit
                  else dbRead(d,'haltezeit',haltezeit);
                  dbClose(d);
                end;
                AddNewBrett(FirstEmpfaenger, BrettKommentar, pollbox_str(zconnect,false),
                  Haltezeit, Grnr, iif(netztyp in netsRFC,16,0));
                if newbrettende then
                  SetBrettindexEnde
                else
                  SetBrettindex;
                writeln(brettlog,logstr(Mid(FirstEmpfaenger,2)));
                end;   { aufnehmen }
              end    { not dbFound }
            else
              // AM for an existing group
              if dbReadInt(bbase,'flags') and 4<>0 then
                // twit filter disabled for this group
                aufnehmen:=true;
            if aufnehmen then
              _brett:=mbrettd(FirstChar(FirstEmpfaenger),bbase);
            end;

          { hier kein adrok: TO-User werden immer aufgenommen! }
          if FirstChar(FirstEmpfaenger)='U' then begin
            dbSeek(ubase,uiName,UpperCase(copy(FirstEmpfaenger,2,80))); {Adrebuch-Eintrag}
            if not dbFound then begin
              dbAppend(ubase);
              name:=copy(FirstEmpfaenger,2,79);
              pb:=pollbox_str(zconnect,true);
              if cpos('@',name)=0 then name:=LeftStr(name+'@'+pb+'.ZER',79);
              dbWriteNStr(ubase,ub_username,name);
              dbWriteNStr(ubase,ub_pollbox,pb);
              dbWriteN(ubase,ub_haltezeit,stduhaltezeit);
              flags:=1+iif(newuseribm,0,8);  { aufnehmen / Umlaute }
              dbWriteN(ubase,ub_userflags,flags);
              adrbuch:=NeuUserGruppe;
              dbWriteN(ubase,ub_adrbuch,adrbuch);
              end
            else begin
              dbReadN(ubase,ub_adrbuch,adrbuch);
              if adrbuch=0 then begin
                adrbuch:=NeuUserGruppe;
                dbWriteN(ubase,ub_adrbuch,adrbuch);
                end;
              end;
            _brett:=mbrettd('U',ubase);
            end;

          if(Aufnehmen and(BoxPar^.ReplaceOwn or BoxPar^.ReplaceDupes))and(hdp.MsgId<>'')then begin
            OwnMessageReplaced:= KillSameMsgId;
            if BoxPar^.ReplaceDupes and MsgIdsRead.Find(msgid,dummy)then begin
              // this msg already showed up in this buffer
              aufnehmen:=false;  // prevent sorting in message
              msgsent:=true;     // prevent putting this message to /Nix
              debug.debuglog('xp3o','dupe (multiple times in buffer)',dltrace);
              end;
            end
          else
            OwnMessageReplaced:= False;

          IsGelesen:=ParGelesen or sendbuf or
                     ((netztyp=nt_Maus) and (FirstChar(pm_bstat)='G')) or
                     (filterattr and fattrGelesen<>0) or
                     (pflags and pe_gelesen<>0) or (ReplaceOwnHoldFlag < 255);

          Debug.DebugLog('xp3o.inc', 'vor aufnehmen=' + iifs(Aufnehmen, 'true', 'false'), DLDebug);

          if aufnehmen then
          begin
            if FirstChar(FirstEmpfaenger)<>'U' then
            begin
              dbReadN(bbase,bb_flags,flags);
              if not IsGelesen and (flags and 2 = 0) then
              begin
                inc(flags,2);                 { ungelesene Nachricht(en) }
                dbWriteN(bbase,bb_flags,flags);
              end;
              if smdl(dbReadInt(bbase,'ldatum'),_datum) then
                dbWriteN(bbase,bb_ldatum,_datum);      { Datum der neuesten Msg }
            end;
            dbAppend(mbase);
            mnt:=netztyp and $FF;
            if References.Count > 0 then inc(mnt,$100); // rckwrtsverkettet
            if attrib and attrFile<>0 then inc(mnt,$200);
            if pm_reply then inc(mnt,$400);
            if (wab<>'') or (oem.Count > 0) then inc(mnt,$800);
            if Empfaenger.Count >1 then inc(mnt,longint(empfnr) shl 24);
            if ((FirstChar(FirstEmpfaenger)='A') and ntDomainReply(netztyp) and
              IsOwnDomain(GetLastReference)) or
              (filterattr and fattrHilite<>0)
            then
              inc(mnt,$1000);        { Antwort auf eigene Nachricht }
            if UpperCase(charset)='ISO1' then inc(mnt,$2000);
            if komlen>0 then inc(mnt,$8000);

            dbWriteN(mbase,mb_netztyp,mnt);
            dbWriteNStr(mbase,mb_betreff,betreff);
            dbWriteNStr(mbase,mb_absender,absender);
            ld:=ixdat(datum);
            dbWriteN(mbase,mb_origdatum,ld);
            ld:=ixdat(dat);
            dbWriteN(mbase,mb_empfdatum,ld);
            dbWriteN(mbase,mb_groesse,groesse);
            typ1:=UpCase(typ[1]);
            if (typ1<=' ') or (typ1>#126) then typ1:='?';
            if (typ1='M') then typ1:='T';
            dbWriteN(mbase,mb_typ,typ1);
            dbWriteNStr(mbase,mb_mimetyp,LowerCase(Trim(LeftStr(hdp.mime.ctype,CPosX(';',hdp.mime.ctype)-1))));
            dbWriteNStr(mbase,mb_brett,_brett);
            dbWriteN(mbase,mb_ablage,ablage);
            dbWriteN(mbase,mb_adresse,padr);
            size:=groesse+hdsize;
            dbWriteN(mbase,mb_msgsize,size);

            if msgid<>'' then
              msgid2:=FormMsgid(msgid)
            else begin
              if msgid3 = '' then
                msgid3 := dummyid(dbRecno(mbase));
              msgid2 := msgid3;
            end;

            dbWriteNStr(mbase,mb_msgid,msgid2);
            if ntEditBrettempf(netztyp) then   { Fido, QWK }
              dbWriteNStr(mbase,mb_name,fido_to)
            else
              dbWriteNStr(mbase,mb_name,realname);
            if IsGelesen then begin
              flags:=1;
              dbWriteN(mbase,mb_gelesen,flags);
              if sendbuf then dbWriteN(mbase,mb_unversandt,flags);
              end;
            flags:=0;
            if filterattr and fattrLoeschen<>0 then flags:=2;
            if filterattr and fattrHalten<>0 then flags:=1;
            if ReplaceOwnHoldFlag < 255 then
            begin
              Flags := ReplaceOwnHoldflag;
              ReplaceOwnHoldFlag := 255;
            end;
            dbWriteN(mbase,mb_halteflags,flags);

                                                   {Fuer User spezifizierte Farbe einstellen}
            if uflags and $E0 <> 0 then
             mbflags:=longint((uflags and $E0) shr 2)
                                                   { Prioritaeten in anderer Farbe.... }
            else if hdp.Priority=5 then mbflags:=32          { Niedrigste }
            else if hdp.Priority=4 then mbflags:=16+8   { Niedrig    }
            else if hdp.Priority=2 then mbflags:=16     { Hoch       }
            else if hdp.Priority=1 then mbflags:=8      { hoechste   }

            else if zconnect and (hdp.Prio>0) then      { und fuer Zconnect ....  }
              if hdp.Prio<=10 then mbflags:=16          { hoch     }
              else mbflags:=8                            { hoechste }
            else mbflags:=0;

            // set  HeaderOnly flags
            if (UpperCase(hdp.XPMode) = 'HDRONLY') and (hdp.Groesse=0) then
              mbflags:=mbflags or 64;

            mbflags:=mbflags or iif(boundary<>'',4,0);
            { this message replaces an old own message; mark it as an own }
            { message again. Necessary for cancels. }
            if OwnMessageReplaced then mbflags:= mbflags or 256;

            { this message could not be identified as SPAM or HAM, set
              ``potentially SPAM'' flag }
            if (not is_spam)and(not is_ham)and spam_ok  then
              mbflags:= mbflags or 64;
              
            dbWriteN(mbase,mb_flags,mbflags);

            if ntKomKette(hdp.netztyp) then 
            begin
              l:=LongInt(LongWord(ixdat(datum)) and LongWord($fffffff0));
              if Empfaenger.Count >1 then
                inc(l,iif(msgsent,2,1));
              AddNewBezug(dbRecno(mbase),hdp.MsgId,hdp.GetLastReference,l);
            end;

            if UsePGP and (pgpflags and fPGP_haskey<>0) and
               ((PGP_AutoAM and (firstchar(FirstEmpfaenger)='A')) or
                (PGP_AutoPM and (firstchar(FirstEmpfaenger)='1')))
            then begin
              savecursor;
              sichern(sp);
              PGP_ImportKey(true);
              holen(sp);
              restcursor;
            end;
            if (firstchar(FirstEmpfaenger)='1') and UsePGP and
               (pgpflags and fPGP_encoded<>0) then
              DecPGP else
            if (firstchar(FirstEmpfaenger)='1') and
               (LeftStr(betreff,length(PMC_ID))=PMC_ID) then
              pmCryptDecode;

            msgsent:=true;
          end;
          (* else begin   { nicht aufnehmen }
            wrll(0);
            wrll(0);
            end; *)

          inc(empfnr); // iterate through recipients
        end;           { with hdp }
        
        if msgsent then
          TestControlMessage;

        if (hdp.Empfaenger.Count>1) and
           (empfnr>hdp.Empfaenger.Count) and
           not msgsent and
           not IsCancelMsg then
        begin
          { Nachricht nach /Junk }
          junk:=true;
          empfnr:=1;            { kein passendes Brett fuer Crossposting }
          if RefList.Count > 0 then
            RefList.Delete(RefList.Count-1); // delete last made entry
          // seek(pfile,filesize(pfile)-16);
          { seek(pfile,filesize(pfile)-8*hdp.empfanz); }
          { seek(pfile,filesize(pfile)-4*max(0,2*hdp.empfanz-llanz));
          llanz:=max(0,llanz-2*hdp.empfanz); }
        end;
    (*  else
          if junk then begin
            FlushLL;
            seek(pfile,sizeof(pfile));   { 0/0-Eintrge fr nicht einsor- }
            end;                         { tierte Xpostings berspringen  } *)

      until (empfnr>hdp.Empfaenger.Count)or(forcerecipient<>'');

      Debug.DebugLog('xp3o','ok, next message',DLDebug);
      if BoxPar^.ReplaceDupes then
        MsgIdsRead.Add(hdp.msgid);
      inc(adr,hdp.groesse+hdsize);
      inc(padr,hdp.groesse+hdsize);
      inc(inmsgs);
      if ((inmsgs mod 3) = 0) then begin        { User beruhigen }
        moff;
        FWrt(x+3+length(mstr),y+4,strs((inmsgs * 100) div MsgCount)+'%');
        mon;
      end;
    until adr>=fs-3;     { 3 Byte Toleranz }
    MsgIdsRead.Destroy;
    f_str.Free;
    Spam.Free;

    Debug.DebugLog('xp3o','index built',DLInform);
    moff;
    FWrt(x+3+length(mstr),y+4,getres2(324,7));
    mon;
    dbrestartHU(mbase);
    dbFlush(mbase);
    close(f);
    inc(ablsize[ablage],fs);
    Debug.DebugLog('xp3o','db flushed',DLInform);

    if zconnect then
      Bezugsverkettung;

    close(cmessagefile);
    if not ignoreSupCancel then
      bearbeite_cancels_supersedes;
    erase(cmessagefile);
    Debug.DebugLog('xp3o','ctrl msgs done',DLInform);

    if not replace_ed then write_lastcall(dat);
    FlushClose;
    close(brettlog);
    close(userlog);
    puffereinlesen:=true;

(*    Wrt(x+2,y+7,getres(320)); { 'Datumsbezge werden berarbeitet...     %' }
    GotoXY(WhereX-5, WhereY);
    Debug.DebugLog('xp3o','set area date',DLInform);
    BrettDatumSetzen(true);
    GotoXY(WhereX-2, WhereY);
    moff; Wrt2(getres(321)); mon;  { ' fertig.' } *)
    Debug.DebugLog('xp3o','finished',DLInform);

    mheadercustom[1]:=cust_header; { Custom-Header wieder zuruecksetzen }
  end   { if Puffer_ok }

  else begin
    close(f);
    moff;
    msgbox(78,9,getres2(336,1),x,y);    { 'ACHTUNG !!!' }
    attrtxt(col.colmboxhigh);

    if check then begin
      FWrt(x+2,y+2,getres2(336,2)+FileUpperCase(puffer));   { 'Fehlerhafte Pufferdatei:  ' }
      Debug.DebugLog('xp3o','buffer corrupted: "'+puffer+'"',DLError);
      end
    else begin
      FWrt(x+2,y+2,getres2(336,3));    { 'Zu wenig Platz auf der Festplatte.' }
      Debug.DebugLog('xp3o','insufficent disk space',DLError);
      end;
    FWrt(x+2,y+3,getres2(336,4));      { 'Puffer wurde NICHT eingelesen!' }
    if pflags and pe_Bad<>0 then begin
      MoveToBad(puffer);
      FWrt(x+2,y+5,getres2(336,5));    { 'Datei wurde im Unterverzeichnis BAD abgelegt.' }
      logerror(getres2(336,6));   { 'Fehlerhafter Netcallpuffer wurde im Unterverzeichnis BAD abgelegt.' }
      end
    else
      logerror(getres2(336,8)+puffer);   { 'Netcallpuffer wurde nicht eingelesen: ' }
    attrtxt(col.colmbox);
    mon;
    errsound;
    moff;
    Wrt(x+2,y+7,getres(12));   { 'Taste drcken ...' }
    mon;
    errsound;
    cursor(curon);
    wkey(180,true);    { max. 3 Minuten }
    cursor(curoff);
    closebox;
    end;

  for i := 0 to RefList.Count - 1 do
  begin
    RefItem := RefList[i];
    Dispose(RefItem);
  end;
  RefList.Free;
  
  Hdp.Free;
  freeres;
  freemem(p,bufsize);
  closebox;
  aufbau:=true; xaufbau:=true;
  Debug.DebugLog('xp3o','finished message import',DLInform);
end;


{ Datei fn ins Unterverzeichnis BAD\ verschieben; ggf. umbenennen }
{ Die Datei befindet sich normalerweise im XP- oder im SPOOL-     }
{ Verzeichnis.                                                    }

procedure MoveToBad(fn:string);
var
    name : string;
    ext  : string;
    f    : file;
begin
  ext:= ExtractFileExt(fn);
  name:= ExtractFilename(fn);
  if (ext<>'') then
    Delete(name, length(name)-length(ext),length(ext));
  if FileUpperCase(ext)=ExtOut then exit;   { UUCP: ausgehende Nachrichten }
  if ext='' then
    ext:='.001'
  else
    while FileExists(BadDir+name+ext) and (ext<>'.999') do
      ext:='.'+formi(ival(mid(ext,2))+1,3);
  SafeDeleteFile(BadDir+name+ext);
  if not FileExists(BadDir+name+ext) then begin
    assign(f,fn);
    rename(f,BadDir+name+ext);
    if ioresult<>0 then;
    end;
end;
