{   $Id: xp8.inc 6974 2005-08-20 22:07:37Z stell $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ Fido FileScan }

procedure SendFilescan(var fn:string);
var leer : string;
begin
  leer:='';
  forcebox:=boxpar^.boxname;
  if DoSend(true,fn,false,false,BoxPar^.filescanner+'@'+boxpar^.boxname,
            boxpar^.FilescanPW,false,false,false,false,false,
            nil,leer,0) then;
end;


procedure GetFilescanBox(var box:string);
begin
  box:=UniSel(1,false,DefFidoBox);
  if box='' then exit;
  if ntBoxNetztyp(box)<>nt_Fido then begin
    rfehler1(852,box);     { '%s ist keine Fido-Box!' }
    box:='';
    end
  else
    ReadBoxpar(nt_Fido,box);
end;


function fileechomarkfunc(const s:string; block:boolean):boolean;
begin
  if trim(s)='' then begin
    if not block then errsound;
    fileechomarkfunc:=false;
    end
  else
    fileechomarkfunc:=true;
end;

function fileechocolfunc(const s:string; line:longint):byte;
begin
  if (s<>'') and (s[1]='*') then
    fileechocolfunc:=col.ColMapsBest
  else
    fileechocolfunc:=0;
end;

function echoname(s:string):string;
begin
  s:=trim(s);
  while FirstChar(s)<'0' do DeleteFirstChar(s);
  if blankpos(s)>0 then truncstr(s,blankpos(s)-1);
  echoname:=s;
end;

procedure FilescanList(art:shortint);     { 1=bestellen, 2=abbestellen }
var
    box : string;
    fl  : string;
    ask : string;
    s   : string;
    t   : text;
    fn  : string;
    anz : longint;
    brk : boolean;
  List: TLister;

label
  again;
begin
  GetFilescanBox(box);
  if box='' then exit;
  fl:=GetServerFilename(box, extFbl);
  if not FileExists(fl) then begin
    rfehler1(853,box); exit;
    end; 
  List := TLister.CreateWithOptions(1,iif(_maus and ListScroller,Screenwidth-1,screenwidth),4,screenlines-fnkeylines-1,-1,'/NS/M/SB/S/'+
             'APGD/'+iifs(_maus and ListScroller,'VSC/',''));
  List.ReadFromFile(fl,0);
  case art of
    1 : showkeys(12);
    2 : showkeys(11);
  end;
again:
  List.OnTestMark := FileechoMarkfunc;
  List.OnColor := FileechoColfunc;
  brk := List.Show;
  if not brk then begin
    anz:=List.SelCount;
    if anz=0 then anz:=1;
    if (anz=1) and (echoname(List.FirstMarked)='') then begin
      errsound;
      goto again;
      end;
    case art of
      1 : ask:=getres2(852,iif(anz=1,1,2));
      2 : ask:=getres2(852,iif(anz=1,3,4));
    end;
    if anz=1 then ask:=reps(ask,echoname(List.FirstMarked))
    else ask:=reps(ask,strs(anz));
    if not ReadJN(ask,true) then
      goto again;
    fn:=TempS(20000);
    assign(t,fn);
    rewrite(t);
    s:=List.FirstMarked;
    while s<>#0 do begin
      write(t,iifc(art=1,'+','-'),echoname(s),#13#10);
      s:=List.NextMarked;
      end;
    close(t);
    SendFilescan(fn);
    _era(fn);
    end;
  freeres;
  List.Free;
  aufbau:=true;
end;


procedure AddFileechos;
begin
  FilescanList(1);
end;


procedure RemoveFileechos;
var
    echo   : string;
    _brett : string;
    box    : string;
    s      : string;
    brk    : boolean;
    d      : DB;
    n,i    : longint;
    fn     : string;
    t      : text;
begin
  echo:='';
  brk:=false;
  if (aktdispmode=10) and not dbEOF(mbase) and not dbBOF(mbase) then begin
    _brett:= dbReadNStr(mbase,mb_brett);
    dbSeek(bbase,biIntnr,mid(_brett,2));
    if dbFound and (ntBoxNetztyp(dbReadStrN(bbase,bb_pollbox))=nt_Fido) then begin
      echo:= dbReadNStr(bbase,bb_brettname);
      if FirstChar(echo) ='A' then 
        DeleteFirstChar(echo)
      else 
        echo:='';
      end;
    end
  else if (aktdispmode=-1) or (aktdispmode=0) then
    if bmarkanz>0 then
      case ReadIt(length(getres2(852,6))+4,getres2(852,6),getres2(852,7),1,brk) of
        1 : echo:='*';          { 'alle markierten File Areas abbestellen' }
        2 : brk:=true;
        3 : echo:='';
      end
    else begin
      if dbreccount(bbase)=0 then 
        brk:=true
      else begin
        echo := dbReadStrN(bbase,bb_brettname);
        if (ntBoxNetztyp(dbReadStrN(bbase,bb_pollbox))<>nt_Fido) or (FirstChar(echo)<>'A') then 
          echo:=''
        else 
          DeleteFirstChar(echo);
      end;
    end;
  if brk then begin
    freeres; exit; end;
  if (echo<>'') and (echo<>'*') and (pos('/files/',LowerCase(echo))>0) then begin
    s:=getreps2(852,5,LeftStr(echo,40));
    case ReadIt(max(length(s)+4,40),s,getres2(852,7),1,brk) of
      1 : begin end;
      2 : brk:=true;
      3 : echo:='';
    end;
    end;
  freeres;
  if brk then exit;

  fn:=TempS(20000); assign(t,fn);
  if (echo='') or ((echo<>'*') and (pos('/files/',LowerCase(echo))=0)) then
    FilescanList(2)                                     { Auswahl aus Liste }
  else if echo<>'*' then begin          { ein Brett abbestellen }
    ReadBoxPar(nt_Fido,dbReadStrN(bbase,bb_pollbox));
    rewrite(t);
    delete(echo,1,length(boxpar^.magicbrett));
    if LowerCase(LeftStr(echo,6))='files/' then delete(echo,1,6);
    write(t,'-',echo,#13#10);
    close(t);
    SendFilescan(fn);
    _era(fn);
    end
  else begin                            { markierte Bretter abbestellen }
    dbOpen(d,BoxenFile,1);
    while not dbEOF(d) do begin
      if dbReadInt(d,'netztyp')=nt_Fido then
      begin
        box:= UpperCase(dbReadStr(d,'boxname'));
        ReadBoxPar(nt_Fido,box);
        n:=0;
        for i:=0 to bmarkanz-1 do begin
          dbGo(bbase,bmarked^[i]);
          echo:= dbReadNStr(bbase,bb_brettname);
          DeleteFirstChar(echo);
          if (UpperCase(dbReadStrN(bbase,bb_pollbox))=box) and
             (LeftStr(UpperCase(echo),length(boxpar^.magicbrett))=UpperCase(boxpar^.magicbrett))
             and (pos('/files/',LowerCase(echo))>0)
          then begin
            if n=0 then rewrite(t);
            delete(echo,1,length(boxpar^.magicbrett));
            if LowerCase(LeftStr(echo,6))='files/' then delete(echo,1,6);
            write(t,'-',echo,#13#10);
            inc(n);
            end;
          end;
        if n>0 then begin
          close(t);
          SendFilescan(fn);
          end;
        end;
      dbNext(d);
      end;
    dbClose(d);
    SafeDeleteFile(fn);
  end;
end;


procedure FilescanReadlist;
var fa  : FidoAdr;
    box : string;
begin
  if (aktdispmode<10) or (aktdispmode>19) or (mbNetztyp<>nt_Fido) then
    rfehler(850)     { 'Keine Filescan-Nachricht gewhlt!' }
  else begin
    splitfido(dbReadStrN(mbase,mb_absender),fa,DefaultZone);
    box:=MakeFidoAdr(fa,false);
    if not IsBox(box) then
      rfehler1(851,box)    { '%s ist kein eingetragener Fido-Server!' }
    else begin
      message(getreps(850,box));       { 'Fileecho-Liste fr %s wird eingelesen ...' }
      extract_msg(xTractMsg,'',GetServerFilename(box, extFbl),false,0);
      mdelay(500);
      closebox;
      end;
    end;
end;


{ Fileecho-Liste aus Datei nach .FBL einlesen }

procedure FilescanReadfile;
var
    box     : string;
    bfile   : string;
    fn      : string;
    useclip : boolean;
begin
  box:=UniSel(1,false,DefaultBox);
  if box='' then exit;   { brk }
  if ntBoxNetztyp(box)<>nt_Fido then begin
    rfehler1(852,box);    { '%s ist keine Fido-Box!' }
    exit;
    end;
  fn:=WildCard;
  useclip:=true;
  if not ReadFilename(getres(822),fn,true,useclip) then exit;   { 'Fileecho-Liste einlesen' }
  bfile := GetServerFilename(Box, '');
  ReadBox(0,bfile,boxpar);
  message(getreps(806,UpperCase(box)));   { 'Fileecho-Liste fr %s wird eingelesen ...' }
  Filecopy(fn, bfile + extFbl);
  Closebox;
  if useclip or ReadJN(getreps(817,fn),false) then   { '%s lschen' }
    _era(fn);
end;


procedure FilescanCommands(cmd:shortint);
var
  List: TLister;
    box  : string;
    comm : string;
    s    : string;
    n,i  : integer;
    brk  : boolean;
    fn   : string;
    t    : text;
    x,y  : Integer;
begin
  GetFilescanbox(box);
  if box='' then exit;
  brk:=false;
  if cmd=1 then
    comm:='LIST'
  else begin
    n:=ival(getres2(851,2));                          { 'Nachricht an %s' }
    List := listbox(ival(getres2(851,0)),n,getreps2(851,1,boxpar^.filescanner+' @ '+box));
    for i:=1 to n do
      List.AddLine(' '+getres2(851,i+2));
    brk := List.Show;
    closebox;
    if not brk then
    begin
      comm:=trim(List.GetSelection);
      TruncStr(comm,pos('  ',comm)-1);
    end;
    List.Free;
  end;
  if comm='PWD' then begin
    dialog(43,3,'',x,y);
    s:=boxpar^.FilescanPW;
    maddstring(3,2,getres2(851,20),s,12,12,'>'); mhnr(87);
    readmask(brk);
    enddialog;
    if not brk then comm:=comm+' '+s;
    end;
  if not brk then begin
    fn:=TempS(2048);
    assign(t,fn);
    rewrite(t);
    write(t,'%',comm,#13#10);
    close(t);
    SendFilescan(fn);
    _era(fn);
    end;
  freeres;
end;
