{   $Id: xp8fs.inc 6974 2005-08-20 22:07:37Z stell $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{----- Fileserver --------------------------------------------------}

function IsServer(box:string; var fstype:byte):boolean;
var d     : DB;
    flags : smallword;
begin
  dbOpen(d,SystemFile,1);
  dbSeek(d,siName,UpperCase(box));
  if dbFound then begin
    dbRead(d,'flags',flags);
    dbRead(d,'fs-typ',fstype);
    end;
  dbClose(d);
  IsServer:=dbFound and (flags and 1<>0);
end;

{ Erstellt aus einem Boxnamen (bis 20 Zeichen) einen Filenamen, der nur
  8+3 Zeichen lang ist }

function MangleBoxName(const s: String): String;
begin
  if Length(s) <= 8 then
    MangleBoxName := s
  else
    MangleBoxName := LeftStr(s, 4) + Hex(CRC32Str(UpperCase(s)), 4);
  Result := FileUpperCase(Result);
end;


{ msg => aktuelle Nachricht wird eingelesen }

procedure FS_ReadList(msg:boolean);
const
      tbufs = 2048;
var
    absender : string;
    box      : string;   { das ist auf jeden Fall eine Zerberus-Box.. }
    convert  : string;
    x,y,p,p2 : Integer;
    f        : file;
    fn       : string;
    t1,t2    : text;
    s,s2     : string;
    useclip  : boolean;
    fstype   : byte;
    tbuf     : pointer;

  procedure wrl;
  begin
    writeln(t2,s[1],'   ',trim(Mid(s,2)));
  end;

  procedure WriteFST(typ:byte);
  var d : DB;
  begin
    dbOpen(d,SystemFile,1);
    dbSeek(d,siName,UpperCase(box));
    if dbFound then
      dbWrite(d,'fs-typ',typ);
    dbClose(d);
  end;

  procedure GetConvert;
  var d : DB;
  begin
    dbOpen(d,SystemFile,1);
    dbSeek(d,siName,UpperCase(box));
    convert:= dbReadStr(d,'ZBV1');
    dbClose(d);
  end;

begin
  if msg then begin
    if (LeftStr(UpperCase(dbReadStrN(mbase,mb_betreff)),5)<>'FILES') and
       not ReadJN(getres(811),true) then   { 'Sind Sie sicher, da das eine Fileliste ist' }
      exit;
    absender:= dbReadStrN(mbase,mb_absender);
    p:=cpos('@',absender);
    p2:=p+cPos('.',copy(absender,p+1,20));
    if (p=0) then begin { or (p2 = 0) rausgenomme!!  MK 12/99 }
      trfehler(809,60);   { 'fehlerhafter Absender!?' }
      exit;
      end;
    box:=copy(absender,p+1,p2-p-1);
    if not IsServer(box,fstype) then begin
      trfehler1(810,box,60);   { 'Das System %s ist nicht als Fileserver eingetragen.' }
      exit;
      end;
    end
  else begin
    fn:=FilePath+WildCard;
    useclip:=false;
    if not readfilename(getres(812),fn,true,useclip) then exit;   { 'Fileserver-Liste' }
    if not FileExists(fn) then begin
      rfehler(811);   { 'Datei ist nicht vorhanden.' }
      exit;
      end;
    box:=UniSel(3,false,'');
    if box='' then exit;
    if not IsServer(box,fstype) then begin
      trfehler1(812,UpperCase(box),60);   { '%s ist kein Fileserver.' }
      exit;
      end;
    end;

  msgbox(48,3,'',x,y);
  mwrt(x+3,y+1,getreps(813,UpperCase(box)));   { 'File-Liste fr %s wird eingelesen ...' }
  if msg then begin
    fn:=TempS(dbReadInt(mbase,'groesse')+5000);
    assign(f,fn);
    rewrite(f,1);
    XreadF(dbReadInt(mbase,'msgsize')-dbReadInt(mbase,'groesse'),f);
    close(f);
    end;
  getmem(tbuf,tbufs);
  assign(t1,fn);
  settextbuf(t1,tbuf^,tbufs);
  reset(t1);
  if fstype<3 then begin
    s:=''; s2:='';
    while not eof(t1) and
          ((pos('Typ',s)=0) or (pos('Dateiname',s)=0)) and
          ((pos('Name',s)=0) or (pos('Beschreibung',s)=0)) and
          (pos(' file description ',LowerCase(s))=0) do begin
      s2:=s;
      readln(t1,s);
      end;
    if eof(t1) then begin
      closebox;
      close(t1);
      freemem(tbuf,tbufs);
      if msg then _era(fn);
      trfehler(813,60);   { 'unbekanntes Listenformat :-(' }
      exit;
      end;
    fstype:=iif(pos('Beschreibung',s)>0,1,iif(pos('description',LowerCase(s))>0,2,0));
    WriteFST(fstype);
    end;
  GetServerName(box); { Gro- und Kleinschreibung korrigieren }
  makebak(MangleBoxName(box)+ extFl, ExtBak);
  case fstype of
    0 : begin      { SendZMsg }
          assign(t2,MangleBoxName(box)+ extFl);
          rewrite(t2);
          readln(t1,s);
          repeat
            if copy(s,1,1)='%' then begin           { Kommentarzeile }
              writeln(t2);
              wrl;
              writeln(t2);
              readln(t1,s);
              end
            else
              if (Length(s) >= 2) and (s[1]<>' ') and (s[2]=' ') then begin
                repeat
                  if eof(t1) then s2:=''
                  else readln(t1,s2);
                  if (s2<>'') and (LeftStr(s2,5)='     ') then
                    s:=s+' '+trim(s2);
                until (s2='') or (LeftStr(s2,5)<>'     ');
                wrl;
                s:=s2;
                if (s='') then readln(t1,s);
                end
              else
                readln(t1,s);
          until eof(t1);
          close(t2);
        end;

    1 : begin      { iMLS-Fileserver }
          assign(t2, MangleBoxName(box)+extFl);
          rewrite(t2);
          writeln(t2,s2);
          writeln(t2,s);
          while not eof(t1) do begin
            readln(t1,s); writeln(t2,s);
            end;
          close(t2);
        end;

    2 : begin      { NCB-Mail-Fileserver }
          close(t1); reset(t1);
          assign(t2, MangleBoxName(box)+ extFl);
          rewrite(t2);
          while not eof(t1) do begin
            readln(t1,s); writeln(t2,s);
            end;
          close(t2);
        end;

    3 : begin      { UUCP-Fileserver }
          GetConvert;
          if pos('$INFILE',convert)=0 then
            rfehler(824)    { 'Ungltiger Konvertierer-Eintrag: $INFILE fehlt' }
          else if pos('$OUTFILE',convert)=0 then
            rfehler(825)    { 'Ungltiger Konvertierer-Eintrag: $OUTFILE fehlt' }
          else begin
            exchange(convert,'$INFILE',fn);
            exchange(convert,'$OUTFILE', MangleBoxName(box)+ extFl);
            shell(convert,300,3);
            if errorlevel=1 then rfehler(821);
            end;
        end;

  end;
  close(t1);
  if msg then erase(t1);
  freemem(tbuf,tbufs);
  closebox;
end;


var fstyp : byte;   { 0=SendZMsg, 1=iMLS }

function testmark(const s:string; block:boolean):boolean;
begin
  if (s<>'') and
     (((fstyp=0) and (FirstChar(s)<>'%') and (copy(s,2,1)=' ')) or
      ((fstyp=1) and (LeftStr(s,5)<>'Name-') and (FirstChar(s)<>' ')) or
      ((fstyp=2) and (s<>'') and (s[1]>' ') and (s[1]<'')) or
      ((fstyp=3) and (trim(s)<>''))) then
    testmark:=true
  else begin
    if not block then errsound;
    testmark:=false;
    end;
end;


function UUsendTestSourcefile(var s:string):boolean;
var
  name : string;

   procedure SetDestfile;
   begin
     if getfield(fieldpos+1)='' then
       setfield(fieldpos+1,LowerCase(extractfilename(s)));
   end;

begin
  s:=ExpandFileName(s);
  if FileExists(s) and not isPath(s) then begin
    SetDestfile;
    UUSendTestSourcefile:=true;
  end else begin                        { Datei fehlt }
    if not multipos('*?',s) then
    begin
      if (LastChar(s)<>DirSepa) {and (rc<>0)} then begin
        rfehler(823);               { 'Datei nicht gefunden.' }
        UUsendTestSourcefile:=false;
        exit;
      end;
      s:= AddDirSepa(s)+WildCard;
    end;
    selcol;
    name:=fsbox(screenlines div 2 - 5,s,'','',true,false,false);
    if name='' then
      UUsendTestSourcefile:=false
    else begin
      s:=name;
      SetDestfile;
      UUsendTestSourcefile:=true;
      end;
    end;
end;


{ comm:    '' / 'FILES' / 'HILFE'     }
{ request: 0=nein, 1=SEND, 2=TRANSFER }

procedure FS_command(comm:string; request:byte);
var d     : DB;
    fs    : string;
    fname : string;
    fpass : string;
    hd    : string;
    w     : smallword;
    fn    : string;
    t     : text;
    brk   : boolean;
    s     : string;
    p     : byte;
    enterfiles : boolean;
    List: TLister;

  procedure GetFilelist;
  var dateien : string;
      anz     : longint;
      s       : string;
  label again;
  begin
    showkeys(10);
    List := TLister.CreateWithOptions(1,ScreenWidth,4,screenlines-fnkeylines-1,-1,'/NS/SB/M/NA/S/');
    List.ReadFromFile(MangleBoxName(fs)+ extFl,0);
    List.OnTestMark := testmark;
  again:
    brk := List.Show;
    if not brk then
    begin
      anz:= List.SelCount;
      s:= List.FirstMarked;
      if (anz=0) and not (testmark(s,false)) then
        goto again;
      if anz=0 then anz:=1;
      dateien:=getres2(814,iif(anz<>1,2,1));
      if not ReadJN(reps(reps(getreps2(814,3,strs(anz)),dateien),fs),true)   { '%s %s bei %s bestellen' }
        then goto again;
      freeres;
      end;
    aufbau:=true;
  end;

  procedure GetTransCeiver;
  var adr : string;
  begin
    select(3);
    if selpos=0 then brk:=true
    else begin
      dbGo(ubase,selpos);
      adr:= dbReadNStr(ubase,ub_username);
      if FirstChar(adr)=vert_char then 
      begin
        rfehler(814);    { 'Verteiler sind hier nicht erlaubt.' }
        brk:=true;
        end
      else begin
        rewrite(t);
        writeln(t,'%',adr);
        close(t);
        end;
      end;
  end;

  procedure readservice;
  var s   : string;
      x,y : Integer;
  begin
    diabox(49,5,getres(815),x,y);   { 'Service-Befehl' }
    s:='';
    readstring(x+3,y+2,getres(816),s,32,32,'',brk);    { 'Befehl: ' }
    if not brk then comm:=comm+' '+s;
    closebox;
  end;

  procedure fscomm(comm:string);
  var domain : string;
  begin
    if isbox(fs) then domain:=ntServerDomain(fs)
    else domain:='.ZER';
    if DoSend(true,fn,false,false,fname+'@'+fs+domain,comm,
              false,false,false,false,false,nil,hd,0) then;
  end;

  procedure uucomm(comm:string);
  begin
    forcebox:=fs;
    GetServerName(fs);      { korrekte Schreibweise ermitteln }
    if DoSend(true,fn,false,false,fname+'@'+fs+ntServerDomain(fs),comm,
              false,false,false,false,false,nil,hd,0) then;
  end;

  procedure UUsendfile;
  var x,y    : Integer;
      brk    : boolean;
      source,
      dest   : string;
  begin
    dialog(ival(getres2(818,0)),5,getres2(818,1),x,y);
    source:=WildCard; dest:='';
    maddstring(3,2,getres2(818,2),source,41,70,'>'); mhnr(890);
    msetvfunc(UUsendTestSourcefile);
    maddstring(3,4,getres2(818,3),dest,41,79,'');
    readmask(brk);
    enddialog;
    if FileExists(source) and (dest<>'') then begin
      rewrite(t);
      writeln(t,dest);
      close(t);
      xpsendmessage.EditAttach:=false; xpsendmessage.noCrash:=true;
      GetServerName(fs);      { korrekte Schreibweise ermitteln }
      if DoSend(true,fn,false,false,fname+'@'+fs+ntServerDomain(fs),
                expandfilename(source),
                false,true,false,false,false,nil,hd,0) then;
      end;
  end;

  procedure ReadFiles;
  var x,y : Integer;
  begin
    dialog(ival(getres2(818,10)),3,getres2(818,11),x,y);   { 'UUCP-Filerequest' / 'Dateien ' }
    s:='';
    maddstring(3,2,getres2(818,12),s,43,250,''); mhnr(895);
    readmask(brk);
    if s='' then brk:=true;
    enddialog;
  end;

  function UU_directory:string;
  var s : string;
      p : byte;
  begin
    s:= List.PrevLine;
    while (s<>#0) and (LeftStr(LowerCase(s),10)<>'directory ') do
      s:=List.PrevLine;
    if s=#0 then s:=''
    else begin
      s:=trim(mid(s,11));
      TrimFirstChar(s, '"');
      p:=blankpos(s);
      if p>0 then truncstr(s,p-1);
      if LastChar(s)='"' then DeleteLastChar(s);
      s:=trim(s);
      if s<>'' then begin
        if (LastChar(s)=':') and (cpos('/',s)>0) then
          DeleteLastChar(s);
        if not (LastChar(s) in [':','/']) then
          s:=s+'/';
        end;
      end;
    UU_directory:=s;
  end;

  procedure AskStart;
  begin
    if ReadJN(getres(819),true) then
      AutoCrash:='*'+fs;
  end;

begin
  fs:=UniSel(3,false,'');
  if fs<>'' then begin
    dbOpen(d,SystemFile,1);
    dbSeek(d,siName,UpperCase(fs));
    fname:=dbReadStr(d,'fs-name');
    fpass:=dbReadStr(d,'fs-passwd');
    dbRead(d,'flags',w);
    dbRead(d,'fs-typ',fstyp);
    dbClose(d);
    enterfiles:=not FileExists(MangleBoxName(fs)+extFl);
    if w and 1=0 then
      rfehler(815)      { 'Das gewhlte System ist kein Fileserver!' }
    else if (request>0) and (fstyp<>3) and enterfiles then
      rfehler1(816,fs)  { 'keine Fileliste fr %s vorhanden' }
    else if (comm='SERVICE') and (fpass='') then
      rfehler(817)      { 'Pawort erforderlich - bitte unter /Edit/Systeme eintragen!' }
    else if (comm='SENDEN') and (fstyp<>3) then
      rfehler(822)      { 'Senden ist nur bei UUCP-Fileservern mglich!' }
    else begin
      fn:=TempS(1000);
      assign(t,fn);
      hd:='';
      if fstyp=3 then begin      { UUCP-Fileserver }
        if not isBox(fs) then
          rfehler(820)
        else if comm='FILES' then begin
          GetServerName(fs);
          rewrite(t);
          writeln(t,fpass);
          close(t);
          uucomm('Request');
          end
        else if (comm='') and (request=1) then begin
          if enterfiles then
            ReadFiles
          else
            GetFileList;
          if not brk then begin
            rewrite(t);
            if enterfiles then begin
              s:=s+' ';
              repeat
                p:=blankpos(s);
                writeln(t,LeftStr(s,p-1));
                s:=trimleft(mid(s,p));
              until s='';
              end
            else begin
              FlushClose;
              s:=trim(List.FirstMarked);
              while s<>#0 do begin
                p:=blankpos(s);
                if p>0 then truncstr(s,p-1);
                if multipos(_MPMask,s) then writeln(t,s)
                else writeln(t,UU_directory+s);
                s:=List.NextMarked;
                end;
              List.Free;
              end;
            close(t);
            uucomm('Request');
            AskStart;   { sofort anrufen? }
            end
          else
            if not enterfiles then List.Free;
          end
        else if comm='SENDEN' then
          UUSendfile
        else                     { HILFE, TRANSFER, SERVICE }
          rfehler(819);          { 'Bei UUCP-Fileservern nicht mglich.' }
        end
      else begin                 { SendZMsg/iMLS/NCB-Mail-Fileserver }
        rewrite(t);
        if comm='SERVICE' then writeln(t,'%',fpass)
        else writeln(t);
        close(t);
        if comm='SERVICE' then readservice
        else brk:=false;
        if not brk then
          if request=0 then
            fscomm(comm)
          else begin
            GetFileList;
            if not brk then begin
              if request=2 then    { Transfer }
                GetTransCeiver;
              if not brk then begin
                s:=List.FirstMarked;
                while s<>#0 do begin
                  if fstyp=0 then
                    s:=trim(Mid(s,2));
                  s:=LeftStr(s,cPos(' ',s)-1);
                  fscomm(iifs(request=1,'SEND ','TRANSFER ')+s);
                  s:=List.NextMarked;
                  end;
                AskStart;   { sofort anrufen? }
              end;
            end;
            List.Free;
          end;
        end;
      if existf(t) then
        erase(t);
      end;
    end;
end;
