{   $Id: xpauto.pas 6974 2005-08-20 22:07:37Z stell $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ Nachrichten-Autoversandt; Autoexec }

{$I xpdefine.inc}

unit xpauto;

interface

uses
  sysutils,montage,typeform,fileio,inout,datadef,database,resource, xpheader,
  xp0,xp1,xpglobal, zftools;

type  AutoRec = record                     { AutoVersand-Nachricht }
                  datei   : string;
                  betreff : string;
                  typ     : char;                { 'B' / 'T'       }
                  empf    : string;      { Brett oder User }
                  box     : string;  { optional        }
                  wotage  : byte;                { Bit 0=Mo        }
                  tage    : longint;             { Bit 0=1.        }
                  monate  : smallword;           { Bit 0=Januar    }
                  datum1  : longint;
                  datum2  : longint;
                  flags   : word;       { 1=aktiv, 2=lschen, 4=nderung, 8=supersede }
                  lastdate: longint;
                  lastfd  : longint;             { Dateidatum }
                  lastmid : string;     { letzte verwendete mid }
                end;

procedure AutoRead(var ar:AutoRec);
procedure AutoWrite(var ar:AutoRec);
procedure AutoSend;
function  PostFile(var ar:AutoRec; sendbox:boolean):boolean;
function  AutoShow:string;      { fr XP4D.INC }

procedure AutoExec(startbatch:boolean);
procedure AutoStop;


implementation

uses xp1o,xp3,xp3o,xpsendmessage,xp9bp,xpmaus,xpnt;


procedure AutoRead(var ar:AutoRec);
begin
  with ar do begin
    datei := dbReadStr(auto,'dateiname');
    Betreff := dbReadStr(auto,'betreff');
    dbRead(auto,'typ',typ);
    empf:= dbReadStr(auto,'empfaenger');
    box := dbReadStr(auto,'pollbox');
    dbRead(auto,'wochentage',wotage);
    dbRead(auto,'tage',tage);
    dbRead(auto,'monate',monate);
    dbRead(auto,'datum1',datum1);
    dbRead(auto,'datum2',datum2);
    dbRead(auto,'flags',flags);
    dbRead(auto,'lastdate',lastdate);
    dbRead(auto,'lastfdate',lastfd);
    lastmid := dbReadStr(auto,'lastmsgid');
  end;                    
end;

procedure AutoWrite(var ar:AutoRec);
begin
  with ar do begin
    dbWriteStr(auto,'dateiname',datei);
    dbWriteStr(auto,'betreff',betreff);
    dbWrite(auto,'typ',typ);
    dbWriteStr(auto,'empfaenger',empf);
    dbWriteStr(auto,'pollbox',box);
    dbWrite(auto,'wochentage',wotage);
    dbWrite(auto,'tage',tage);
    dbWrite(auto,'monate',monate);
    dbWrite(auto,'datum1',datum1);
    dbWrite(auto,'datum2',datum2);
    dbWrite(auto,'flags',flags);
  end;
end;


{ nchstes Absendedatum fr Automatik-Nachricht berechnen }
{ 0 -> kein zutreffendes Datum, Nachricht nicht absenden  }

function AutoNextdate(var ar:AutoRec):longint;
var mmask     : array[1..12] of boolean;
    tmask     : array[1..31] of boolean;
    wmask     : array[1..7] of boolean;
    i,_d      : longint;
    dat0,dat2 : fdate;
    dat       : fdate;
    ds        : string;

  function smd(d1,d2:fdate):boolean;
  begin
    smd:=longint(d1)<longint(d2);
  end;

  procedure fitmonth(var _dat:fdate);
  begin
    while not mmask[_dat.m] do
      with _dat do begin
        inc(m);
        if m>12 then begin
          m:=1;
          inc(j);
          end;
        t:=1;
        end;
  end;

  procedure nextd2;
  begin
    incd(dat2);
    fitmonth(dat2);
  end;

  function iid(dat:fdate):longint;
  begin
    with dat do
      iid:=ixdat(formi(j mod 100,2)+formi(m,2)+formi(t,2)+'0000');
  end;

  function amodi:boolean;
  var
    fn : string;
  begin
    fn:=ar.datei;
    adddir(fn,SendPath);
    if not FileExists(fn) then
      Result := false
    else
      amodi:=FileAge(fn)<>ar.lastfd;
  end;

begin
  with ar do
    if not odd(flags) or (monate=0) then
      AutoNextDate:=0
    else
    if (flags and 4<>0) and not amodi then
      AutoNextDate:=0
    else begin
      for i:=1 to 12 do mmask[i]:=monate and (1 shl (i-1)) <> 0;
      for i:=1 to 31 do tmask[i]:=tage and (1 shl (i-1)) <> 0;
      for i:=1 to 7 do  wmask[i]:=wotage and (1 shl (i-1)) <> 0;
      if lastdate=0 then ds:=zdate
      else ds:=longdat(lastdate);
      with dat0 do begin
        j:=ival(LeftStr(ds,2));
        if j<=70 then inc(j,2000)
        else inc(j,1900);
        m:=ival(copy(ds,3,2));
        t:=ival(copy(ds,5,2));
        end;
      if lastdate<>0 then
        incd(dat0);
      fitmonth(dat0);
      longint(dat):=0;
      if tage<>0 then begin
        dat2:=dat0;
        while not tmask[dat2.t] do nextd2;
        if (longint(dat)=0) or smd(dat2,dat) then
          dat:=dat2;
        end;
      if wotage<>0 then begin
        dat2:=dat0;
        while not wmask[ddow(dat2)] do nextd2;
        if (longint(dat)=0) or smd(dat2,dat) then
          dat:=dat2;
        end;
      _d:=iif(tage+wotage=0,0,iid(dat));
      if datum1<>0 then
        if (_d=0) or smdl(datum1,_d) then _d:=datum1;
      if datum2<>0 then
        if (_d=0) or smdl(datum2,_d) then _d:=datum2;
      AutoNextDate:=_d;
      end;
end;


{ In auto mu korrekter Datensatz sein! }

function PostFile(var ar:AutoRec; sendbox:boolean):boolean;
var tmp  : boolean;
    t    : text;
    pm   : boolean;
    leer : string;
    dat  : longint;
    tt   : longint;
    b    : byte;
    muvs : boolean;
    sData: TSendUUData;
begin
  postfile:=false;
  with ar do begin
    if datei<>'' then
      adddir(datei,SendPath);
    if (datei<>'') and not FileExists(datei)
    then
      trfehler1(2201,fitpath(datei,42),30)    { 'AutoVersand - Datei "%s" fehlt!' }
    else if (datei<>'') and (_filesize(datei)=0) then
      trfehler(2202,30)   { 'AutoVersand - 0-Byte-Datei wurde nicht verschickt' }
    else begin
      tmp:=(datei='');
      if tmp then begin
        datei:=TempS(1000);
        assign(t,datei);
        rewrite(t);
        writeln(t);
        close(t);
      end;
      pm:=(cPos('@',empf)<>0);
      if pm and (betreff='') then betreff:='<nope>';
      empf:=vert_long(empf);
      pm:=(cPos('@',empf)<>0);
      if not pm then insert('A',empf,1);
      leer:='';
      if UpperCase(box)='*CRASH*' then begin
        box:='';
        xpsendmessage.flCrash:=true;
        xpsendmessage.NoCrash:=true;    { keine Rckfrage 'sofort versenden' }
        end;
      forcebox:=box;
      if not tmp then begin
        sendfilename:=ExtractFileName(datei); {GetFileName(datei);}
        sendfiledate:=ZCfiletime(datei);
        end;
      if forcebox='' then dbGo(mbase,0);   { keine Antwort auf Brettmsg }
      EditAttach:=false;
      muvs:=SaveUVS; SaveUVS:=false;
      sdata:= TSendUUData.Create;
      if (flags and 8<>0) then sData.Ersetzt := dbReadStr(auto,'lastmsgid');
      if DoSend(pm,datei,tmp,false,empf,betreff,false,typ='B',sendbox,false,false,
                sData,leer,sendShow) then begin
        b:=0;
        dbWriteN(mbase,mb_gelesen,b);
        dat:=ixdat(zdate);
        dbWrite(auto,'lastdate',dat);
        dbWriteStr(auto,'lastmsgid',sData.msgid);
        tt := FileAge(Datei);
        dbWrite(auto,'lastfdate', tt);
        if dat>=datum1 then begin
          datum1:=0;
          dbWrite(auto,'datum1',datum1);
          end;
        if dat>=datum2 then begin
          datum2:=0;
          dbWrite(auto,'datum2',datum2);
          end;
        if (flags and 2<>0) and (datum1=0) and (datum2=0) and (tage+wotage=0)
        then begin
          if ExtractFileExt(FileUpperCase(datei))=FileUpperCase('.msg') then
            SafeDeleteFile(datei);
          dbDelete(auto);
          aufbau:=true;
          end;
        end;
      SaveUVS:=muvs;
      if tmp then
        SafeDeleteFile(datei);
      sData.Free
    end;
  end;
end;


procedure AutoSend;
var ar    : AutoRec;
    dat   : longint;
    r1,r2 : longint;
begin
{$IFDEF Debug }
  dbLog('-- AutoVersand');
{$ENDIF }
  dbOpen(auto,AutoFile,1);
  dbSetIndex(auto,0);
  dbGoTop(auto);
  while not dbEOF(auto) do begin
    AutoRead(ar);
    dat:=AutoNextdate(ar);
    if (dat<>0) and not smdl(ixDat(zdate),dat) and (length(ar.empf)>1) then begin
      r1:=dbRecno(auto);
      dbSkip(auto,1);
      r2:=dbRecno(auto);
      dbGo(auto,r1);
      if PostFile(ar,false) then;
      dbGo(auto,r2);
      end
    else
      dbNext(auto);
    end;
  dbClose(auto);
end;


{ --- AutoExec ------------------------------------------------------ }

procedure AutoExec(startbatch:boolean);
const tfs = 20;
var sr    : tsearchrec;
    rc    : integer;
    first : boolean;
    ctlEbest,ctlErstDat : boolean;
    mgel  : boolean;       { Save fr ParGelesen }
    fnstart: string;      { Name der Start.bat }

  function find(const ext:string):boolean;
  begin
    if first then
      rc:= findfirst(AutoxDir+'*'+FileUpperCase(ext),faAnyFile,sr)
    else
      rc:= findnext(sr);
    first:=(rc<>0);
    find:=not first;
    if first then findclose(sr);
  end;

  function NamePollbox:string;
  var p : byte;
      d : DB;
  begin
    p:=cpos('.',sr.name);
    dbOpen(d,BoxenFile,1);
    dbSeek(d,boiDatei,LeftStr(sr.name,p-1));
    if dbFound then
      NamePollbox:=dbReadStr(d,'boxname')
    else
      NamePollbox:='';
    dbClose(d);
  end;

  function MausImport:boolean;
  var box : string;
  begin
    MausImport:=false;
    if not FileExists(MaggiBin) then
      trfehler(102,tfs)    { 'MAGGI.EXE fehlt' }
    else begin
      box:=NamePollbox;
      if box='' then
        trfehler1(2204,sr.name,tfs)   { 'Kann %s nicht einlesen - ungltige Pollbox' }
      else begin
        ReadBoxpar(0,box);
        shell(MaggiBin+' -sz -b'+box+' -h'+boxpar^.MagicBrett+' '+
              AutoxDir+sr.name+' MPUFFER',300,3);
        if errorlevel<>0 then
          trfehler1(2205,sr.name,tfs)   { '%s: Fehler bei Nachrichtenkonvertierung' }
        else begin
          MausLogFiles(0,false,box);
          MausLogFiles(1,false,box);
          MausLogFiles(2,false,box);
          MausImport:=PufferEinlesen('MPUFFER',box,ctlErstDat,false,ctlEbest,0);
          _era('MPUFFER');
          end;
        end;
      end;
  end;

  procedure FidoImport;
  var x,y: Integer;
  begin
    if not IsBox(DefFidoBox) then
      trfehler(2207,tfs)     { 'Keine gltige Fido-Stammbox gewhlt' }
    else begin
      ReadBoxpar(0,DefFidoBox);
      msgbox(70,10,GetRes2(30003,10),x,y);
      DoZFido(2, BoxPar^.MagicBrett, AutoxDir+'*.pkt', 'FPUFFER', '', '', 0, '', '', true, false, false, false, x, y);
      closebox;
      if errorlevel<>0 then
        trfehler(2208,tfs)   { 'Fehler bei Fido-Paketkonvertierung' }
      else begin
        if PufferEinlesen('FPUFFER',DefFidoBox,ctlErstDat,false,ctlEbest,pe_ForcePfadbox) then begin
          erase_mask(AutoXDir+'*.pkt');
          erase_mask(AutoXDir+'*.PKT');
        end;
        DeleteFile('FPUFFER');
      end;
    end;
  end;

  function SendMsg(delfile:boolean):boolean;
  var t1,t2 : text;
      p     : byte;
      empf  : string;
      betr  : string;
      box   : string;
      datei : string;
      hdr   : string;
      s     : string;
      err   : boolean;
      temp  : boolean;
      pm    : boolean;
      attach: boolean;   { Fido-FileAttach }
      nt    : byte;

    procedure axerr(nr:word; txt:string);
    begin
      tfehler(getres2(2200,1)+getreps2(2200,nr,txt),tfs);   { 'AutoExec-Fehler: ' }
      freeres;
    end;

  begin
    SendMsg:=false;
    empf:=''; betr:='';
    box:=''; datei:='';
    assign(t1,AutoxDir+sr.name);
    reset(t1);
    s:='*';
    while not eof(t1) and (s<>'') do begin
      readln(t1,s);
      p:=cpos(':',s);
      if p>0 then begin
        hdr:=LowerCase(LeftStr(s,p-1));
        if (hdr='empfaenger') or (hdr='empfnger') or (hdr='to') then
          empf:=trim(mid(s,p+1)) else
        if (hdr='betreff') or (hdr='subject') then
          betr:=trim(mid(s,p+1)) else
        if hdr='server' then
          box:=trim(mid(s,p+1)) else
        if (hdr='datei') or (hdr='file') then
          datei:=FileUpperCase(trim(mid(s,p+1)));
        end;
      end;
    err:=true;
    if box<>'' then
      nt:=ntBoxNetztyp(box)
    else
      nt := 255; // nt is undefined

    attach:=(box<>'') and (datei<>'') and
            ((nt=nt_Fido) or
             (nt=nt_UUCP) and (LeftStr(empf,16)='UUCP-Fileserver@'));
    if empf='' then axerr(2,'') else    { 'Empfnger fehlt' }
    if betr='' then axerr(3,'') else    { 'Betreff fehlt'   }
    if (box<>'') and not IsBox(box) then
      axerr(4,box) else                 { 'ungltige Serverbox: %s' }
    if datei<>'' then begin
      if not multipos(_MPMask,datei) then
        datei:=SendPath+datei;
      if not FileExists(datei) then
        axerr(5,UpperCase(datei)) else       { 'Datei "%s" fehlt' }
      if attach and (cpos('@',empf)=0) then
        axerr(6,'') else   { 'File Attaches knnen nur als PM verschicht werden!' }
      if attach and (length(datei)>BetreffLen) then
        axerr(7,'')        { 'Pfadname zu lang fr File Attach' }
      else
        err:=false;
      end
    else
      err:=false;
    if err then begin
      close(t1);
      exit;
      end;

    if attach then begin
      betr:=datei;
      datei:='';
      EditAttach:=false;    { ab hier kein EXIT mehr! }
      end;

    if datei='' then begin
      datei:=TempS(_filesize(AutoxDir+sr.name));
      temp:=true;
      assign(t2,datei); rewrite(t2);
      while not eof(t1) do begin
        repeat
          readln(t1, s);
          writeln(t2, s);
        until eoln(t1);
      end;
      close(t2);
    end
    else begin
      temp:=false;
      SendFilename:=ExtractFilePath(datei); {getfilename(datei);}
      SendFiledate:=zcfiletime(datei);
      end;
    close(t1);
    s:='';
    forcebox:=box;
    empf:=vert_long(empf);
    p:=cpos('@',empf);
    pm:=(p>0);
    if pm then
      empf:=trim(LeftStr(empf,p-1))+'@'+trim(mid(empf,p+1))
    else
      if FirstChar(empf)<>'/' then empf:='/'+empf;
    EditAttach:=false;
    if DoSend(pm,datei,temp or delfile,false,iifs(pm,'','A')+empf,betr,
              false,attach or not temp,false,false,temp,nil,s,sendShow) then begin
//      if temp or (delfile and (datei<>'')) then
//        DeleteFile(datei);
      SendMsg:=true;
      end;
  end;

  function SendPuffer:boolean;
  var
    box: String;
  begin
    SendPuffer:=false;
    box:=NamePollbox;
    if not IsBox(box) then
      trfehler1(2209,box,tfs)    { 'IPS - ungltige Box: %s' }
    else
      if PufferEinlesen(AutoxDir+sr.name,box,false,true,false,0) then begin
        AppPuffer(box,AutoXdir+sr.name);
        SendPuffer:=true;
        end
      else
        SendPuffer:=false;
  end;

  procedure SetCTL;
  begin
    if LeftStr(sr.name,6)='EBEST.'   then ctlEbest:=true else
    if LeftStr(sr.name,7)='EDATUM.'  then ctlErstDat:=true else
    if LeftStr(sr.name,8)='GELESEN.' then ParGelesen:=true;
  end;

begin
{$IFDEF Debug }
  dbLog('-- AutoExec');
{$ENDIF }
  if not isEmptyDir(AutoxDir) then begin
    first:=true;
    ctlEbest:=false; ctlErstDat:=false;
    mgel:=ParGelesen; ParGelesen:=false;
    while find('.ctl') do    { Control-Dateien }
      SetCTL;
    while find('.ctd') do begin
      SetCTL;
      DeleteFile(AutoXdir+sr.name);
      //delfile;
      end;
    while find('.zer') do     { Z-Puffer einlesen + lschen }
      if PufferEinlesen(AutoxDir+sr.name,NamePollbox,ctlErstDat,false,ctlEbest,0) then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    while find('.zee') do     { Z-Puffer einlesen, EB's versenden + lschen }
      if PufferEinlesen(AutoxDir+sr.name,NamePollbox,ctlErstDat,false,true,0) then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    while find('.out') do     { Maus-OUTFILE einlesen + lschen }
      if MausImport then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    if FileExists(AutoxDir+'*.pkt') then    { Fido-Paket(e) einlesen + lschen }
      FidoImport;

    while find('.ips') do     { Puffer versenden }
      if SendPuffer then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    while find('.msg') do     { Nachricht/Datei senden + lschen }
      if SendMsg(false) then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    while find('.msd') do     { Datei senden + incl. Datei lschen }
      if SendMsg(true) then
        DeleteFile(AutoXdir+sr.name);
        //delfile;
    while find(ExtBak) do     { BAK-files lschen }
      DeleteFile(AutoXdir+sr.name);
      //delfile;

    while find('.bat') do     { Batchdateien ausfhren }
      if (LeftStr(FileUpperCase(sr.name),5)<>FileUpperCase('start')) and
        (LeftStr(FileUpperCase(sr.name),4)<>FileUpperCase('stop')) then begin
        shell(AutoxDir+sr.name,600,1);
        DeleteFile(AutoXdir+sr.name);
      end;
    if startbatch then begin
      fnstart:=AutoxDir+FileUpperCase('start' + extBatch);        { START.BAT }
      if FileExists(fnstart) then
        shell(fnstart,500,1);
      fnstart:=AutoxDir+FileUpperCase('start1' + extBatch);       { START1.BAT, lschen }
      if FileExists(fnstart) then begin
        shell(fnstart,500,1);
        DeleteFile(fnstart);
        end;
      end;
    ParGelesen:=mgel;
  end;
end;

procedure AutoStop;
var
  fnstop: string;
begin
{$IFDEF Debug }
  dbLog('-- AutoStop');
{$ENDIF }
  fnstop:= AutoxDir+FileUpperCase('stop' + extBatch);     { STOP.BAT }
  if FileExists(fnstop) then
    shell(fnstop,500,1);
  fnstop:= AutoxDir+FileUpperCase('stop1' + extBatch);    { STOP1.BAT, lschen }
  if FileExists(fnstop) then 
  begin
    shell(fnstop,500,1);
    _era(fnstop);
  end;
end;


function AutoShow:string;      { fr XP4D.INC }
var ar   : autorec;
    c    : string;
    ldat,
    sdat : string;

  procedure setfile(var s: string);
{$IFDEF UnixFS }
  begin
    s:= ExtractFilename(s);
{$ELSE }
  var dir  : string;
      name : string;
  begin
    dir:= ExtractFilePath(s);
    name:= ExtractFileName(s);
    if dir='' then s:=name
    else if (Length(dir) >= 2) and (dir[2]=':') then
      s:=LeftStr(dir,2)+name
    else s:=LeftStr(GetCurrentDir,2)+name;
{$ENDIF }
  end;

begin
  AutoRead(ar);
  with ar do begin
    if typ='T' then typ:=' ';
    c:=iifs(odd(flags),'+ ','  ');
    ldat:=LeftStr(fdat(longdat(lastdate)),5);
    if ldat='00.00' then ldat:='--.--';
    sdat:=LeftStr(fdat(longdat(AutoNextDate(ar))),5);
    if (sdat='00.00') or (empf='') then sdat:='--.--';
    setfile(datei);
    AutoShow:=c+forms(datei,15)+typ+' '+ldat+'  '+sdat+'  '+
              forms(empf,22)+' '+forms(betreff,24)+ dup(ScreenWidth-80, ' ');
    end;
end;

end.
