{   $Id: xpfido.pas 6977 2005-08-21 05:25:24Z stell $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ Nodelist }

{$I xpdefine.inc}

unit xpfido;

interface

uses  xpglobal,
{$IFDEF NCRT }
  xpcurses,
{$ENDIF }
  sysutils,typeform,fileio,inout,keys,winxp,maus2,
  maske,lister,archive,stack,resource,datadef,database,
  xp0,xp1,xp1o,xp1input,fidoglob;

const nfComp   = $0001;
      nfHST    = $0002;
      nfV32    = $0004;
      nfV32b   = $0008;
      nfPEP    = $0010;
      nfZYXEL  = $0020;
      nfHST16  = $0040;
      nfCM     = $0080;
      nfISDN   = $0100;
      nfTerbo  = $0200;
      nfVFC    = $0400;
      nfV34    = $0800;

      rfWaZOO  = $0001;
      rfUpWaz  = $0002;
      rfBark   = $0004;
      rfUpBark = $0008;

      NodeChar = '0123456789:/.';
      crashID  = 'crash';

type  nodeinfo = record
                   found    : boolean;
                   ispoint  : boolean;
                   status   : string;
                   boxname  : string;
                   standort : string; { 03.02.2000 MH: 40 -> 65 }{ unbedenklich }
                   sysop    : string;
                   telefon  : string;
                   baud     : word;
                   fflags   : string; { MH: 40 -> 80 } { unbedenklich }
                   flags    : word;
                   request  : word;
                   datei    : byte;     { Nummer der Nodeliste }
                 end;

procedure MakeNodelistIndex;
procedure OpenNodeindex(const fn:string);
procedure CloseNodeindex;
procedure GetNodeinfo(const adr:string; var ni:nodeinfo; pointtyp:integer);
function  IsFidoNode(const adr:string):boolean;
function  FidoIsISDN(const fa:FidoAdr):boolean;
{ returns node name if node supports BinkP; node name may not be a valid IP }
{ address, there seems to be no standard :-( }
function  FidoIsBinkP(var fa:FidoAdr):string;
procedure KeepNodeindexOpen;
procedure KeepNodeindexClosed;
procedure GetNodeuserInfo(var fa:FidoAdr; var ni:NodeInfo);

function  FidoRequest(node,files:string):string;
{ procedure FidoTransfer; }
function  FidoSeekfile:string;
procedure ReadFidolist;
procedure DelFidolist;

function  TestNodelist:boolean;
function  testDefbox:boolean;

function  FidoFilename(const fa:FidoAdr):string;
function  CrashFile(adr:string):string;
procedure GetReqFiles(adr:string; var files:string);
function  FidoPhone(var fa:FidoAdr; var nl_phone:string):string;
function  FidoAppendRequestfile(var fa:FidoAdr):string;
procedure ShrinkPointToNode(var fa:FidoAdr; var ni:NodeInfo);
function  FindFidoAddress(const fn:string; var fa:FidoAdr):boolean;

procedure NodelistBrowser;

procedure SetCrash(adr:string; insert:boolean);
procedure SetRequest(const adr,files:string);  { '' -> Request lschen }

procedure NodelistIndex;
procedure NodelistSeek;
procedure SetShrinkNodelist;
procedure ShrinkNodelist(indizieren:boolean);

function  ReqTestNode(var s:string):boolean;
procedure FileSelProc(var cr:customrec);
function  fstestmark(const s:string; block:boolean):boolean;
procedure NodeSelProc(var cr:customrec);


implementation

uses  xpnt,xp2,xp3,xp4e,
{$IFDEF Linux}
  oldlinux, // for stat & fsstat
{$ENDIF}
xpfidonl;


{ --- Nodelisten ----------------------------------------------------- }

const bersize   = 200;     { Max. Netze pro Bereich }
      maxber    = 300;
      maxnodes  = 3000;    { max Nodes / Net }
      maxpoints = 700;     { max Points / Node }
      nodekenn  = 'IDX'^Z;
      MaxNamelen= 30;      { max. Namenslnge in Userindex }
      blocksize = 1024;    { Blockgre in Userindex }

type  noderec = packed record
                  node : smallword;
                  adr  : longint;
                end;
      nodea   = array[0..maxnodes-1] of noderec;
      pointrec= packed record
                  point : smallword;
                  adr   : longint;
                end;
      pointa  = array[0..maxpoints-1] of pointrec;
      berrec  = packed record             { Netzindex - Bereich }
                  fromnet  : smallword;
                  fromzone : smallword;
                  anz      : smallword;
                  adr      : longint;
                end;
      netrec  = packed record case integer of
                  0 : (net  : smallword;
                       zone : smallword;
                       anz  : smallword;
                       fnr  : byte;   { Datei-Nr. }
                       flags: byte;   { 1=Pointliste }
                       adr  : longint);
                  1 : (sortl : longint);
                end;
      netrecl = array[1..bersize] of netrec;

      userrec = packed record
                  name : string[MaxNamelen];
                  adr  : array[0..3] of smallword;  { Zone:Net/Node.Point }
                  fnr  : byte;                 { Nodelisten-Dateinr. }
                  fadr : longint;
                end;
      unodep  = ^usernode;
      usernode= packed record
                  left,right : unodep;
                  user       : userrec;
                end;

      idxheader = packed record
                    kennung : array[0..3] of char;
                    beradr  : longint;    { Adresse Bereichsindex }
                    bernum  : smallword;  { Anzahl Bereiche       }
                    adrnetx : longint;    { Adresse Netzindex     }
                    fill    : array[0..49] of byte;
                  end;

      udxheader = packed record
                    kennung : array[0..3] of char;
                    anzahl  : longint;
                    blocks  : longint;
                    version : smallword;
                  end;

type  bereichlst = array[1..maxber] of berrec;

const nodelistopen : boolean = false;

var   NX_adrnetx   : longint;
      bereiche     : word;
      berliste     : ^bereichlst;
      nodef        : file;
      nodelf       : file;
      FreqLst      : string;
      DelFilelist  : boolean;   { lokal NodeSelProc }
      UserBlocks   : longint;


procedure MakeNodelistIndex;
const tbuf     = 8192;
      nbuffers = 32;
var x,y        : Integer;
    nf         : text;
    idf,tf     : file;
    p          : byte;
    s          : string;
    k          : string;
    ss         : string;
    zone,net   : word;
    node,nodes : word;
    l          : longint;
    liste,ltyp : byte;
    np         : ^nodea;
    tb         : pointer;
    newnet     : boolean;
    new_net    : word;
    new_zone   : word;
    fpos       : longint;
    res        : integer;
    nets       : word;
    _netr      : netrec;
    nbuffer    : array[1..nbuffers] of netrec;
    ll         : byte;
    bufnets    : word;
    ixh        : idxheader;
    fa         : FidoAdr;
    points     : integer;
    pp         : ^pointa;

    uroot      : unodep;
    chunksize  : longint;   { User pro Spur }
    chunks     : longint;   { Spuren }
    users      : longint;   { User im akt. Chunk }
    gusers     : longint;   { User gesamt }
    uf         : array[0..1] of ^file;

  procedure Display;
  begin
    attrtxt(col.colmboxhigh);
    moff;
    Wrt(x+31,y+2, Format('%d:%d', [zone, net])); Wrt2(sp(x+40-wherex));
    Wrt(x+49,y+2, Format('%6d', [gusers]));
    mon;
  end;

  procedure wrmsg(txt:string);
  begin
    attrtxt(col.colmbox);
    mwrt(x+3,y+2,forms(txt,55));
  end;

  procedure SortTempindex(l,r:longint);
  var i,j : longint;
      x   : longint;
      w,z : netrec;

    function nrx(ll:longint):longint;
    var nr : netrec;
    begin
      seek(tf,ll*sizeof(netrec));
      blockread(tf,nr,sizeof(netrec));
      nrx:=nr.sortl;
    end;

  begin
    i:=l; j:=r;
    x:=nrx((l+r) div 2);
    repeat
      while nrx(i)<x do inc(i);
      while nrx(j)>x do dec(j);
      if i<=j then begin
        seek(tf,i*sizeof(netrec)); blockread(tf,w,sizeof(netrec));
        seek(tf,j*sizeof(netrec)); blockread(tf,z,sizeof(netrec));
        seek(tf,i*sizeof(netrec)); blockwrite(tf,z,sizeof(netrec));
        seek(tf,j*sizeof(netrec)); blockwrite(tf,w,sizeof(netrec));
        inc(i); dec(j);
        end;
    until i>j;
    if l<j then sorttempindex(l,j);
    if r>i then sorttempindex(i,r);
  end;

  procedure WriteBerindex;
  var
      r    : berrec;
      na   : ^netrecl;
      rr   : Integer;
      add  : word;
      bpos : longint;
  begin
    new(na);
    seek(tf,0);
    bpos:=0;
    repeat
      inc(ixh.bernum);
      if eof(tf) then     { keine Daten -> keine Listen, leerer Index }
        fillchar(r,sizeof(r),0)
      else begin
        blockread(tf,na^,sizeof(na^),rr);
        rr:=rr div sizeof(netrec);
        add:=0;
        if rr=bersize then begin
          while na^[bersize-add].sortl=na^[bersize-add-1].sortl do
            inc(add);
          inc(add);    { letzes Netz in diesem Bereich knnte = 1. Netz im }
                       { nchsten sein..                                   }
          seek(tf,filepos(tf)-add*sizeof(netrec));
          end;
        r.fromnet:=na^[1].net;
        r.fromzone:=na^[1].zone;
        r.anz:=rr-add;
        r.adr:=bpos;
        end;
      blockwrite(idf,r,sizeof(r));
      inc(bpos,r.anz*sizeof(netrec));
    until eof(tf);
    dispose(na);
  end;

  procedure CopyNetindex;
  const bs = 2048;
  var p  : pointer;
      rr : Integer;
  begin
    getmem(p,bs);
    seek(tf,0);
    repeat
      blockread(tf,p^,bs,rr);
      blockwrite(idf,p^,rr);
    until eof(tf);
    freemem(p,bs);
  end;

  { --- User-Indizierung --------------------------------------------- }

  procedure WriteU;
  const ubufsize = 100;
  type  ubufa    = array[0..ubufsize-1] of UserRec;
  var   ubuf     : ^ubufa;
        ubufs    : word;
        lusers   : longint;

    procedure FlushUbufs;
    begin
      blockwrite(uf[0]^,ubuf^,ubufs*sizeof(userrec));
      ubufs:=0;
    end;

    procedure WriteDelU(var node:unodep);
    begin
      if node<>nil then with node^ do begin
        WriteDelU(left);
        ubuf^[ubufs]:=user;
        inc(ubufs);
        if ubufs=ubufsize then FlushUbufs;
        WriteDelU(right);
        dispose(node);
        end;
    end;

  begin
    lusers:=users;
    blockwrite(uf[0]^,lusers,4);
    new(ubuf); ubufs:=0;
    WriteDelU(uroot);
    uroot:=nil;
    if ubufs>0 then FlushUBufs;
    dispose(ubuf);
    users:=0;
    inc(chunks);
  end;

  procedure AppUser(zone,net,_node,point:word; fpos:longint);
  var name : string;
      i    : integer;

    procedure AppU(var node:unodep);
      procedure setname;
      begin
        node^.user.name:=name;
      end;
      function smallname:boolean;
      begin
        smallname:=(name<node^.user.name);
      end;
    begin
      if node=nil then begin
        new(node);
        fillchar(node^,sizeof(node^),0);
        setname;
        with node^.user do begin
          adr[0]:=zone; adr[1]:=net;
          adr[2]:=_node; adr[3]:=point;
          fnr:=liste;
          fadr:=fpos;
          end;
        end
      else
        if SmallName then
          AppU(node^.left)
        else
          AppU(node^.right);
    end;

  begin
    for i:=1 to 3 do begin
      if p>0 then delete(s,1,p);
      p:=cpos(',',s);
      end;
    if p>0 then begin
      name:=LeftStr(s,p-1);
      p:=length(name);
      while (p>1) and (name[p]<>'_') do dec(p);
      if p>1 then
        name:=mid(name,p+1)+' '+LeftStr(name,p-1);
      for i:=1 to length(name) do
        if name[i]='_' then name[i]:=' ';
      name:= UpperCase(name); { UpString(name);}
      AppU(uroot);
      inc(users); inc(gusers);
      if users=chunksize then
        WriteU;
      end;
  end;

  procedure SortChunks;
  var ufpos  : byte;
      i,cc   : longint;
      durchl : integer;   { Anzahl Durchlufe }
      nn     : integer;   { akt. Durcklauf }

    procedure MergeChunks(f0,f1:byte);
    const ubufmax = 1000;
    type  ubufa   = array[0..ubufmax-1] of userrec;
    var bufsize   : word;
        bufanz    : word;
        buf       : array[1..3] of ^ubufa;
        bp        : array[1..3] of word;
        anz,banz  : array[1..2] of longint;
        ranz      : array[1..2] of longint;   { schon gelesene User }
        pos       : array[1..2] of longint;
        rn        : byte;
        total     : longint;

      procedure ReadBuf(nr:byte);
      begin
        banz[nr]:=min(anz[nr]-ranz[nr],bufanz);
        if banz[nr]>0 then begin
          seek(uf[f0]^,pos[nr]);
          blockread(uf[f0]^,buf[nr]^,banz[nr]*sizeof(userrec));
          pos[nr]:=filepos(uf[f0]^);
          inc(ranz[nr],banz[nr]);
          end;
        bp[nr]:=0;
      end;

      procedure FlushOutbuf;
      begin
        blockwrite(uf[f1]^,buf[3]^,bp[3]*sizeof(userrec));
        bp[3]:=0;
      end;

      procedure WrUser(nr:byte);
      begin
        buf[3]^[bp[3]]:=buf[nr]^[bp[nr]];
        inc(bp[nr]);
        if bp[nr]=banz[nr] then ReadBuf(nr);
        inc(bp[3]);
        if bp[3]=bufanz then FlushOutbuf;
      end;

    begin
      bufsize:=ubufmax*sizeof(userrec);
      bufanz:=bufsize div sizeof(userrec);
      bufsize:=bufanz*sizeof(userrec);     { Gre abrunden }
      getmem(buf[1],bufsize);
      getmem(buf[2],bufsize);
      getmem(buf[3],bufsize);
      bp[1]:=0; bp[2]:=0; bp[3]:=0;
      blockread(uf[f0]^,anz[1],4);
      pos[1]:=filepos(uf[f0]^);
      pos[2]:=pos[1]+anz[1]*sizeof(userrec)+4;
      seek(uf[f0]^,pos[2]-4);
      blockread(uf[f0]^,anz[2],4);      { <- Lesefehler! }
      total:=anz[1]+anz[2];
      blockwrite(uf[f1]^,total,4);
      ranz[1]:=0; ranz[2]:=0;
      ReadBuf(1); ReadBuf(2);
      while (bp[1]<banz[1]) and (bp[2]<banz[2]) do
        if buf[1]^[bp[1]].name<buf[2]^[bp[2]].name then
          WrUser(1)
        else
          WrUser(2);
      if bp[1]<banz[1] then rn:=1
      else rn:=2;
      while bp[rn]<banz[rn] do
        WrUser(rn);
      if bp[3]>0 then
        FlushOutbuf;
      seek(uf[f0]^,pos[2]);
      freemem(buf[3],bufsize);
      freemem(buf[2],bufsize);
      freemem(buf[1],bufsize);
    end;

  begin
    spush(chunks,sizeof(chunks));
    durchl:=0;
    while chunks>1 do begin    { zhlen }
      i:=1; cc:=chunks;
      while i<chunks do begin
        inc(i,2); dec(cc); end;
      chunks:=cc;
      inc(durchl);
      end;
    spop(chunks);

    ufpos:=0; nn:=0;
    while chunks>1 do begin    { sortieren }
      inc(nn);
      attrtxt(col.colmboxhigh);
      mwrt(x+30,y+2,strs(nn)+'/'+strs(durchl));
      seek(uf[0]^,0); seek(uf[1]^,0);
      truncate(uf[1-ufpos]^);
      i:=1; cc:=chunks;
      while i<chunks do begin
        MergeChunks(ufpos,1-ufpos);
        inc(i,2);
        dec(cc);
        end;
      if i=chunks then
        fmove(uf[ufpos]^,uf[1-ufpos]^);    { einzelnen Chunk kopieren }
      chunks:=cc;
      ufpos:=1-ufpos;
      { chunksize:=chunksize*2; }
      end;

    close(uf[1-ufpos]^);
    erase(uf[1-ufpos]^);
    if ufpos=1 then
      Move(uf[1]^,uf[0]^,sizeof(file));
  end;

  procedure MakeUserIndex(xx:byte);     { Userindex komprimieren, user-Name -fidoAdresse -AdresseNlEintrag }
  const ubufanz   = 100;                { werden komprimiert in user.idx abgespeichert }
  type  block     = array[0..blocksize-1] of byte;
        ubufa     = array[0..ubufanz-1] of userrec;
  var   bbuf      : ^block;
        ubuf      : ^ubufa;
        uihd      : udxheader;
        bufp,bufanz:word;
        lname     : string[MaxNamelen];
        user      : UserRec;
        cuser     : array[0..50] of byte;       { komprimierter User-Record }
        cuserp    : byte;
        outp      : word;                       { Position in bbuf }
        w         : word;
        b,adrf    : byte;
        nn        : longint;
        ok        : boolean;

    procedure ReadUbuf;
    var 
      rr: Integer;
    begin
      blockread(uf[0]^,ubuf^,sizeof(ubufa),rr);
      bufanz:=rr div sizeof(userrec);
      bufp:=0;
    end;

    procedure FlushOut;
    begin
      attrtxt(col.colmboxhigh);
      mwrt(xx,y+2,strsn(nn*100 div uihd.anzahl,3));
      bbuf^[outp]:=$ff;
      blockwrite(uf[1]^,bbuf^,blocksize);
      fillchar(bbuf^,blocksize,0);
      outp:=0;
      lname:='';
    end;

  begin         { procedure MakeUserIndex(xx:byte);      Userindex komprimieren  }
    fillchar(uihd,sizeof(uihd),0);
    uihd.kennung:=nodekenn;
    seek(uf[0]^,0);
    blockread(uf[0]^,uihd.anzahl,4);
    new(bbuf);
    fillchar(bbuf^,blocksize,0);
    seek(uf[1]^,sizeof(uihd));
    blockwrite(uf[1]^,bbuf^,blocksize-sizeof(uihd));
    new(ubuf);
    ReadUbuf;
    lname:=''; outp:=0;
    nn:=0;
    while bufp<bufanz do begin
      inc(nn);
      user:=ubuf^[bufp];      { user.name :string[30]; adr: array[0..3] of smalword; fnr:byte        ; fadr :longint}
      inc(bufp);              { username               zone/net/node               Nodelistennummer    adresse in der nodelist }
      if bufp=bufanz then ReadUbuf;
      with user do
        repeat
          cuserp:=0;                                            { Lnder der abzuspeichernden Daten }
          { R-}
          b:=0; w:=min(length(name),length(lname));             { user.name, lname = name des letzten Eintrages}
          while (b<w) and (name[b+1]=lname[b+1]) do inc(b);     { aktueller username im letzten usernamen enthalten oder gleich? }
          cuser[cuserp]:=b; inc(cuserp,2);                      { curser[0]= Anzahl der gleichen chars,curse[1] wird bersprungen inhalt adrf }
          w:=length(name)-b;                                    { Lnge des Namens (Anzahl der ungleichen Zeichen )}
          cuser[cuserp]:=w; inc(cuserp);        { Name }        { curser[2]=Lnge Namen, Zeiger+1}
          if w>0 then                                           { curser[3]=Anzahl derungleiche Zeichen }
            Move(name[b+1],cuser[cuserp],w);                    { Name nach curser[3] und}
          inc(cuserp,w);                                        { Zeiger um Lnge Namen erhhen }
          lname:=name;                                          { aktuellen Namen in lname merken }
          adrf:=0;                                              { adrf:byte, bitfeld zum merken div. Eigenschaften }
          if (adr[0]>0) and (adr[0]<16) then    { Zone }        { passt user zone in 4 Bit }
            inc(adrf,adr[0]*16)                                 { ja, adrf=user.ddr[0] geshiftet um 4 }
          else begin
            cuser[cuserp]:=lo(adr[0]);                          { nein, user zone in zwei bytes sichern }
            cuser[cuserp+1]:=hi(adr[0]);                        { swap}
            inc(cuserp,2);                                      { zeiger+2 }
            end;
          cuser[cuserp]:=lo(adr[1]); inc(cuserp);   { Net }     { net speichern }
          if adr[1]<256 then                                    { passt net in ein Byte }
            inc(adrf,1)                                         { ja, lsb in adef setzen}
          else begin
            cuser[cuserp]:=hi(adr[1]); inc(cuserp);             { nein, dann  net in zwei bytes speicher }
            end;
          cuser[cuserp]:=lo(adr[2]); inc(cuserp);   { Node }    { das gleiche Spiel mit der node Adresse }
          if adr[2]<256 then                                    { passt in ein byte }
            inc(adrf,2)                                         { ja, bit 1 setzen }
          else begin
            cuser[cuserp]:=hi(adr[2]); inc(cuserp);             { nein, dann noch zweites byte speichern }
            end;
          if adr[3]=0 then                                      { Point ? }
            inc(adrf,4)                                         { nein, bit 2 setzen }
          else begin
            cuser[cuserp]:=lo(adr[3]); inc(cuserp);             { nein, point# speichern }
            if adr[3]<256 then                                  { passt point in ein byte }
              inc(adrf,8)                                       { bit 3 setzen }
            else begin
              cuser[cuserp]:=hi(adr[3]); inc(cuserp);
              end;
            end;
          cuser[1]:=adrf;       { Adre-Flag  bit 0  - net  in einem byte gespeichert }
                                {             bit 1  - node in einem byte gespeichert }
                                {             bit 2  - is node (keine point# gespeicheret }
                                {             bit 3  - point in einem byte gespeichert }
                                {             bit 4..7 -zonen#, wenn zone# <16         }

          if fnr=0 then         { nummer der nodeliste, 0 = keine Nodeliste bei Dos/16 oder }
            inc(cuser[2],$40)   { bit 6 setzen          0 = ertser Eintrag in der Tlist }
          else begin
            cuser[cuserp]:=fnr;                 { nodelisten# speichern  }
            inc(cuserp);                        { zeiger + 1 }
            end;
          if fadr<$1000000 then begin           { passt Adress in 3 byte }
            inc(cuser[2],$80);                  { ja, msb curser[2] setzen }
            Move(fadr,cuser[cuserp],3);         { ja, adresse nach cuser schieben }
            inc(cuserp,3);                      { Zeiger erhhen }
            end
          else begin
            Move(fadr,cuser[cuserp],4);         { nein, 4-byte Adresse sichern }
            inc(cuserp,4);
            end;
          { R+}
          ok:=(outp+cuserp+1)<=blocksize;       { blockgre erreicht ? }
          if not ok then
            FlushOut                            { ja, block wegschreiben }
          else begin
            Move(cuser,bbuf^[outp],cuserp);     { cuser[], in den Block schreiben }
            inc(outp,cuserp);                   { bytezhler erhhen}
            end;
        until ok;
      end;

    if outp>0 then
      FlushOut;
    seek(uf[1]^,0);
    uihd.blocks:=filesize(uf[1]^) div blocksize - 1;
    blockwrite(uf[1]^,uihd,sizeof(uihd));       { Header schreiben }
    dispose(ubuf);
    dispose(bbuf);
  end;

  procedure SortNodes(l,r:integer);
  var i,j : integer;
      x   : word;
      w   : noderec;
  begin
    i:=l; j:=r;
    x:=np^[(l+r) div 2].node;
    repeat
      while np^[i].node<x do inc(i);
      while np^[j].node>x do dec(j);
      if i<=j then begin
        w:=np^[i]; np^[i]:=np^[j]; np^[j]:=w;
        inc(i); dec(j);
        end;
    until i>j;
    if l<j then sortnodes(l,j);
    if r>i then sortnodes(i,r);
  end;

  procedure writenodes;
  begin
    blockwrite(idf,np^,nodes*sizeof(noderec));
  end;

  procedure writepoints;
  begin
    blockwrite(idf,points,2);
    blockwrite(idf,pp^,points*sizeof(pointrec));
    points:=0;
  end;

  procedure flushnbuffers;
  begin
    blockwrite(tf,nbuffer,bufnets*sizeof(netrec));
    bufnets:=0;
  end;

  procedure AppPoint(pnode:word);
  begin
    if points<maxpoints then begin
      pp^[points].point:=node;
      pp^[points].adr:=fpos;
      inc(points);
      AppUser(zone,net,pnode,node,fpos);
      end;
  end;

begin
  getmem(tb,tbuf);
  msgbox(59,5,getres2(2101,1),x,y) ;   { 'Nodeindex anlegen' }
  mwrt(x+3,y+2,getres2(2101,2));       { 'Datei' }
  mwrt(x+25,y+2,getres2(2101,3));      { 'Netz'  }
  mwrt(x+43,y+2,getres2(2101,4));      { 'User'  }
  new(np); new(pp);
  assign(idf,NodeindexF);
  rewrite(idf,1);
  seek(idf,64);
  assign(tf,'nodes.$$$'); rewrite(tf,1);
  nets:=0; bufnets:=0;
  uroot:=nil; chunks:=0; users:=0; gusers:=0;
  chunksize:= 2566;
  new(uf[0]);
  assign(uf[0]^,'users1.$$$'); rewrite(uf[0]^,1);

  for liste:=0 to NodeList.Count - 1 do
  begin
    zone:=TNodeListItem(Nodelist.Items[liste]).zone;
    if zone=0 then zone:=DefaultZone;
    net:=0; node:=0;
    assign(nf,FidoDir+NodeList.GetFilename(liste));
    ltyp:=TNodeListItem(Nodelist.Items[liste]).fformat;
    case ltyp of
      nlPoints24,
      nl4DPointlist,
      nlFDpointlist : zone:=TNodeListItem(Nodelist.Items[liste]).zone;
      nlNode        : begin
                         zone:=TNodeListItem(Nodelist.Items[liste]).zone;
                         net :=TNodeListItem(Nodelist.Items[liste]).net;
                      end;
    end;

    if existf(nf) then begin
      settextbuf(nf,tb^,tbuf);
      reset(nf);
      attrtxt(col.colmboxhigh);
      mwrt(x+10,y+2,forms(ExtractFileName(filename(nf)),12));
      fpos:=0;
      nodes:=0;
      points:=0;
      repeat
        newnet:=false;
        Display;

        repeat
          readln(nf,s);
          ll:=length(s);
          p:=cpos(',',s);
          if ( FirstChar(s)<>';') and (p>0) then begin
            if (p=1) or (ltyp=nlNode) then begin
              if ltyp=nlFDpointlist then k:='Point'
              else k:='';
              newnet:=false; end
            else begin
              k:=TopStr(copy(s,1,p-1));
              if (ltyp=nlFDpointlist) and (k='Boss') then begin
                ss:=mid(s,p+1);
                p:=cposx(',',ss);
                SplitFido(LeftStr(ss,p-1),fa,zone);
                if fa.zone<>zone then begin
                  k:='Zone'; newnet:=true; end
                else if fa.net<>net then begin
                  k:='Host'; newnet:=true; end
                else if fa.node<>node then begin
                  k:='Node'; newnet:=false; end
                else begin
                  k:=''; newnet:=false; end;
                node:=fa.node;
                new_zone:=fa.zone; new_net:=fa.net;
                end
              else
                newnet:=(k='Host') or (k='Region') or (k='Zone');
              end;

            if (ltyp<>nlFDpointlist) or (k='Point') then begin
              delete(s,1,p);
              p:=cposx(',',s);
              val(LeftStr(s,p-1),l,res);
              node:=minmax(l,0,65535);
              end;

            if node<>0 then case ltyp of

              nlNodelist:
                if not newnet and (nodes<maxnodes) then begin
                  np^[nodes].node:=node;
                  np^[nodes].adr:=fpos;
                  inc(nodes);
                  AppUser(zone,net,node,0,fpos);
                  end;

              nl4DPointlist:
                if k='Point' then
                  if nodes>0 then AppPoint(np^[nodes-1].node)
                  else   { nodes=0 kann vorkommen, wenn falsches Listenformat }
                else
                  if not newnet and (nodes<maxnodes) then begin
                    if points>0 then WritePoints;
                    np^[nodes].node:=node;
                    np^[nodes].adr:=filepos(idf);
                    inc(nodes);
                    end;

              nlFDpointlist:
                if (k='Node') and (nodes<maxnodes) then begin
                  if points>0 then WritePoints;
                  np^[nodes].node:=node;
                  np^[nodes].adr:=filepos(idf);
                  inc(nodes);
                  end
                else
                  if (k='Point') or (k='Pvt') or (k='Down') or (k='Hold') then
                    if nodes>0 then  { sicher ist sicher ... }
                      AppPoint(np^[nodes-1].node);

              nlNode:
                if not newnet then
                  AppPoint(TNodeListItem(Nodelist.Items[liste]).node);

              nlPoints24:
                if not newnet then
                  if nodes>0 then AppPoint(np^[nodes-1].node)
                  else
                else begin
                  if points>0 then
                    WritePoints
                  else
                    if nodes>0 then
                      dec(nodes);   { Node ohne Points !? }
                  if k='Region' then
                    k:='Host'
                  else if (k='Host') and (nodes<maxnodes) then begin
                    newnet:=false;
                    delete(s,1,p);
                    p:=cpos(',',s);
                    splitfido(LeftStr(s,p-1),fa,zone);
                    np^[nodes].node:=fa.node;
                    np^[nodes].adr:=filepos(idf);
                    net:=fa.net;
                    Display;
                    inc(nodes);
                    end;
                  end;

              end;  { case }
            end;  { s[1]<>';' }
          inc(fpos,ll+2);
        until newnet or eof(nf);

        if points>0 then begin
          if nodes=0 then begin       { ntNode }
            np^[0].node:=TNodeListItem(Nodelist.Items[liste]).node;
            inc(nodes);
            end;
          np^[nodes-1].adr:=filepos(idf);
          WritePoints;
          end;

        if nodes>0 then begin
          inc(nets);
          _netr.net:=net;
          _netr.zone:=zone;
          _netr.anz:=nodes;
          _netr.fnr:=liste;
          _netr.flags:=iif(ltyp=nlNodelist,0,1);
          _netr.adr:=filepos(idf);
          inc(bufnets);
          nbuffer[bufnets]:=_netr;
          if bufnets=nbuffers then
            flushnbuffers;
          if nodes>1 then
            SortNodes(0,nodes-1);
          WriteNodes;
          end;
        if ltyp=nlFDpointlist then begin
          zone:=new_zone;
          net:=new_net;
          end;
        if not eof(nf) then begin
          if ltyp<>nlFDpointlist then begin
            if (k<>'Host') and (k<>'Region') then
              zone:=node;
            net:=node;
            np^[0].node:=0;
            np^[0].adr:=fpos-ll-2;
            end
          else begin
            np^[0].node:=node;
            np^[0].adr:=filepos(idf);
            end;

          nodes:=1;
          node:=0;
          if ltyp=nlNodelist then
            AppUser(zone,net,node,0,fpos-ll-2);
          end;
      until eof(nf);
      close(nf);
      end;
    end;

  if bufnets>0 then
    flushnbuffers;
  WriteU;

  fillchar(ixh,sizeof(ixh),0);
  ixh.kennung:=NodeKenn;
  ixh.beradr:=filepos(idf);
  ixh.bernum:=0;  {(nets-1) div bersize +1;}

  attrtxt(col.colmbox);
  wrmsg(getres2(2101,5));   { 'Netzindex sortieren ...' }

  if nets>0 then
    SortTempIndex(0,nets-1);
  seek(idf,ixh.beradr);
  WriteBerindex;
  ixh.adrnetx:=ixh.beradr+ixh.bernum*sizeof(berrec);
  CopyNetindex;

  close(tf);
  erase(tf);
  dispose(pp); dispose(np);

  wrmsg(getres2(2101,6));    { 'Userindex sortieren ...' }
  new(uf[1]); assign(uf[1]^,'users2.$$$');
  rewrite(uf[1]^,1);
  SortChunks;    { schliet+lscht uf[1]^ }
  wrmsg(getres2(2101,7));    { 'Userindex packen ...      %' }
  assign(uf[1]^,UserIndexF);
  rewrite(uf[1]^,1);
  MakeUserindex(x+length(getres2(2101,7))-2);
  close(uf[0]^); erase(uf[0]^); dispose(uf[0]);
  close(uf[1]^); dispose(uf[1]);

  seek(idf,0);
  blockwrite(idf,ixh,sizeof(ixh));
  close(idf);

  freeres;
  closebox;
  freemem(tb,tbuf);
end;


procedure OpenNodeindex(const fn:string);
var hd  : idxheader;
    uhd : udxheader;
    rr  : Integer;
    f   : file;
  procedure NXerror;
  begin
    rfehler(2101);    { 'fehlerhafter Nodelisten-Index' }
    close(nodef);
    erase(nodef);
  end;
begin
  assign(nodef,fn);
  reset(nodef,1);
  fillchar(hd,sizeof(hd),0);
  blockread(nodef,hd,sizeof(hd),rr);
  if (hd.kennung<>nodekenn) or (hd.beradr>=filesize(nodef)) then begin
    NXerror; exit; end;
  nx_adrnetx:=hd.adrnetx;
  bereiche:=hd.bernum;
  getmem(berliste,bereiche*sizeof(berrec));
  seek(nodef,hd.beradr);
  blockread(nodef,berliste^,bereiche*sizeof(berrec));
  close(nodef);
  assign(f,UserIndexF);
  reset(f,1);
  fillchar(uhd,sizeof(uhd),0);
  blockread(f,uhd,sizeof(uhd),rr);
  if (uhd.kennung<>nodekenn) then begin
    close(f);
    NXerror; exit; end;
  UserBlocks:=uhd.blocks;
  close(f);
  Nodelist.Open:=true;
end;


procedure CloseNodeindex;
begin
  freemem(berliste,bereiche*sizeof(berrec));
end;


procedure KeepNodeindexOpen;
begin
  if Nodelist.Open and not nodelistopen then begin
    { new(nodelf);
    assign(nodelf^,nodefile);
    reset(nodelf^,1); }
    nodelistopen:=true;
    reset(nodef,1);
    end;
end;

procedure KeepNodeindexClosed;
begin
  if nodelistopen then begin
    close(nodef);
 {   close(nodelf^);
    dispose(nodelf); }
    nodelistopen:=false;
    end;
end;


function FormFidoPhone(telefon:string):string;
var p : byte;
begin
  if pos('unpublished',LowerCase(telefon))>0 then
    FormFidoPhone:=telefon
  else if LeftStr(telefon,length(vorwahl))=vorwahl then begin
    delete(telefon,1,length(vorwahl));
    TrimFirstChar(telefon, '-');
    FormFidoPhone:=telefon;
    end
  else begin
    p:=cpos('-',vorwahl);
    if LeftStr(telefon,p)=LeftStr(vorwahl,p) then
      FormFidoPhone:=NatVorwahl+mid(telefon,p+1)
    else
      FormFidoPhone:=intVorwahl+telefon;
    end;
end;


{$I xpf1.inc}   { Nodeliste auslesen/abfragen }


procedure NodelistIndex;
begin
  if not TestNodelist then exit;
  CloseNodeindex;
  Nodelist.Open:=false;
  MakeNodelistIndex;
  OpenNodeindex(NodeIndexF);
end;

procedure SetShrinkNodelist;
var x,y   : Integer;
    brk   : boolean;
    s,s2  : string;
    ss    : string;
    p     : byte;
    l     : longint;
    res   : integer;
begin
  if not TestNodelist then exit;
  if NodeList.GetMainNodelist<0 then begin     //bestimmt den index der nodeliste
    rfehler(2125);    { 'Es ist keine Haupt-Fido-Nodeliste (NODELIST.###) eingebunden.' }
    exit;
    end;
  dialog(57,3,getres2(2104,1),x,y);   { 'Nodelist einschrnken' }
  s:=ShrinkNodes;
  maddstring(3,2,getres2(2104,2),s,35,100,'0123456789 :');  { 'Zonen/Regionen ' }
  readmask(brk);
  enddialog;
  if not brk then begin
    if s='' then begin
      ShrinkNodes:='';
      SaveConfig2;
      message(getres2(2104,3));  { 'Einschrnkungen gelscht - ggf. Nodeliste neu einlesen.' }
      wait(curoff);
      closebox;
      freeres;
      exit;
      end;
    s2:=s;
    s:=s+' ';
    repeat
      p:=cpos(' ',s);
      ss:=LeftStr(s,p-1);
      s:=trimleft(mid(s,p));
      p:=cpos(':',ss);
      if p=0 then
        val(ss,l,res)
      else begin
        val(LeftStr(ss,p-1),l,res);
        if res=0 then val(mid(ss,p+1),l,res);
        end;
    until (res<>0) or (s='');
    if res<>0 then
      fehler(getres2(2104,4))   { 'ungltige Eingabe' }
    else begin
      ShrinkNodes:=s2;
      SaveConfig2;
      ShrinkNodelist(true);
      end;
    end;
  freeres;
end;


procedure ShrinkNodelist(indizieren:boolean);
var i : integer;
begin
  i:=NodeList.GetMainNodelist;
  if (i>0) and Nodelist.Open and (trim(ShrinkNodes)<>'') then
  begin
    xp1.shell(OwnPath + 'OPENXP NDIFF.EXE -s '+FidoDir+NodeList.GetFilename(i)+' '+ShrinkNodes,250,3);
    if errorlevel<>0 then
      rfehler(2114)   { 'Fehler beim Bearbeiten der Nodelist' }
    else
      if indizieren then
        MakeNodelistIndex;
  end;
end;


{ --- File Request --------------------------------------------------- }

function ReqTestNode(var s:string):boolean;  { s. auch XP7.getCrashBox }
var fa : FidoAdr;
    ni : NodeInfo;
begin
  if not IsNodeAddress(s) then begin
    fa.username:=s;
    GetNodeuserInfo(fa,ni);
    if ni.found then s:=MakeFidoAdr(fa,true);
    end
  else begin
    splitfido(s,fa,DefaultZone);
    if fa.node+fa.net=0 then begin
      errsound;
      ReqTestNode:=false;
      ni.found:=false;
      end
    else begin
      s:=MakeFidoAdr(fa,true);
      getNodeinfo(s,ni,2);
      end;
    end;
  if not ni.found then begin
    if multipos(':/',s) then
      rfehler(2115);   { 'unbekannte Adresse' }
    ReqTestNode:=false;
    end
  else begin
    fa.ispoint:=ni.ispoint;
    s:=MakeFidoAdr(fa,true);
    ReqtestNode:=true;
    end;
end;

procedure NodeSelProc(var cr:customrec);
var t   : text;
    s   : string;
    p   : byte;
    node: string;
    ni  : nodeinfo;
    anz : longint;
    fn  : string;
    sr  : tsearchrec;
    rc  : integer;
    List: TLister;

begin
  List := listbox(73,15,getres(iif(delfilelist,2105,2106)));
  assign(t,FileLists);          { 'Fileliste lschen','File Request' }
  reset(t);
  anz:=0;
  KeepNodeindexOpen;
  while not eof(t) do begin
    readln(t,s); s:=trim(s);
    p:=cPos('=',s);
    if (s<>'') and (s[1]<>'#') and (s[1]<>';') and (p>0) then begin
      fn:=mid(s,p+1);
      rc:= findfirst(FidoDir+fn,faAnyFile,sr);
      if (rc=0) and (sr.size>0) then begin
        node:=LeftStr(s,p-1);
        GetNodeinfo(node,ni,1);
        inc(anz);
        if cpos('.',fn)>0 then
          fn:=LeftStr(fn,cpos('.',fn)-1);
          List.AddLine(' '+forms(node,14)+' '+
              forms(iifs(ni.found,ni.boxname+', '+ni.standort,'???'),32)+
              '  '+FormatDateTime('mm/yy', FileDateToDateTime(sr.time))+'  '+forms(fn,9)+strsn(sr.size div 1024,5)+'k ');
      end; // if rc...
      FindClose(sr);
    end; // if
  end; // while
  KeepNodeindexClosed;
  close(t);
  if anz>0 then begin
    cr.brk := List.Show;
    if not cr.brk then begin
      cr.s:=trim(LeftStr(List.GetSelection,15));
      if not delfilelist and (copy(List.GetSelection,17,4)<>'??? ') then
        keyboard(keycr+keyf2);
      end;
    end
  else
    cr.brk:=true;
  List.Free;
  closebox;
end;

procedure ShrinkPointToNode(var fa:FidoAdr; var ni:NodeInfo);
var ni2 : NodeInfo;
begin
  if fa.ispoint then begin
    getNodeinfo(MakeFidoadr(fa,false),ni2,1);
    if ni2.found and ((ni2.telefon=ni.telefon) or (pos('unpublished',LowerCase(ni.telefon))>0))
    then begin
      fa.ispoint:=false;
      ni:=ni2;
      end;
    end;
end;


procedure GetFAddress(request:boolean; txt:string; var fa:FidoAdr;
                      var ni:NodeInfo; var brk:boolean; var x,y: Integer);
var node    : string;
    xx,yy,i : Integer;
    t       : taste;
begin
  dialog(38,3,txt,x,y);
  if fa.net+fa.node=0 then
    node:=DefFidoBox
  else
    node:=MakeFidoAdr(fa,true);
  maddstring(3,2,getres(2107),node,20,25,''); mhnr(730);  { 'Node/Name ' }
  if request and FileExists(FileLists) and FileExists(FidoDir+'*' + extFl) then 
  begin
    mappcustomsel(NodeSelproc,false); mselhnr(85);
    DelFilelist:=false;
    end;
  msetvfunc(ReqTestNode);
  readmask(brk);
  enddialog;
  if not brk then begin
    if IsNodeaddress(node) then begin
      SplitFido(node,fa,DefaultZone);
      GetNodeinfo(node,ni,1);
      end
    else begin
      fa.username:=node;
      getNodeUserInfo(fa,ni);
      end;
    if not ni.found then begin      { drfte eigentlich nicht passieren.. }
      rfehler(2116);   { 'unbekannte Nodeadresse' }
      brk:=true;
      end
    else begin
      ShrinkPointToNode(fa,ni);
      node:=MakeFidoAdr(fa,true);
      if request and (ni.request and rfWaZOO=0) then
        brk:=not ReadJN(getres(2108),true);  { 'Laut Nodelist kein Request bei dieser Box mglich - trotzdem versuchen' }
      if not brk and (ni.flags and nfCM=0) and (pos('Kratzenberg',ni.sysop)>0)
      then begin
        msgbox(ival(getres2(2126,0)),res2anz(2126)+4,_hinweis_,xx,yy);
        for i:=1 to res2anz(2126)-1 do
          mwrt(xx+3,yy+1+i,getres2(2126,i));
        mwrt(xx+3,yy+res2anz(2126)+2,getres(12));
        errsound;
        get(t,curon);
        closebox;
        end;
      end;
    end;
  if not brk then begin
    dialog(65,iif(request,10,8),txt,x,y);
    maddtext(3,2,getres2(2109,1),0);   { 'Box' }
    maddtext(3,3,getres2(2109,2),0);   { 'Nummer' }
    maddtext(3,4,getres2(2109,3),0);   { 'Flags' }
    maddtext(3,5,getres2(2109,4),0);   { 'Status' }
    freeres;
    attrtxt(col.coldiahigh);
    maddtext(12,2,iifs(ni.ispoint,ni.sysop,leftStr(ni.boxname+', '+ni.standort,
                                            48-length(node)))+' ('+node+')',
                col.coldiahigh);
    maddtext(12,3,ni.telefon,col.coldiahigh);

    {modem:=''; }
    with ni do begin
    { if flags and nfHST<>0 then modem:='HST';
      if flags and nfHST16<>0 then modem:=modem+' / HST-16.8';
      if flags and nfV32b<>0 then modem:=modem+' / V.32bis'
      else if flags and nfV32<>0 then modem:=modem+' / V.32';
      if flags and nfPEP<>0 then modem:=modem+' / PEP';
      if flags and nfZYXEL<>0 then modem:=modem+' / ZyXEL-16.8';
      if flags and nfISDN<>0 then modem:=modem+' / ISDN';
      if flags and nfTerbo<>0 then modem:=modem+' / V32 terbo';
      if flags and nfVFC<>0 then modem:=modem+' / V.Fast Class';
      if flags and nfV34<>0 then modem:=modem+' / V.34';

      if FirstChar(modem)=' ' then delete(modem,1,3);
      if modem='' then modem:=strs(baud);
      maddtext(12,4,modem,col.coldiahigh); }


      { Fix: Flagzeile zu lang: gekrzt und E-Mail rausschneiden }
      maddtext(12, 4, copy(MailString(FFlags, True), 1, 50), col.coldiahigh);
      maddtext(12, 5, status, col.coldiahigh);

      end;
    end;
end;

function TestNodelist:boolean;
begin
  if not Nodelist.Open then
    rfehler(2102);   { 'keine Nodelist aktiv' }
  TestNodelist:=Nodelist.Open;
end;

function testDefbox:boolean;
begin
  if DefFidoBox='' then
    rfehler(2118);   { 'keine Fido-Stammbox gewhlt (Edit/Boxen)' }
  testDefbox:=(DefFidobox<>'');
end;

function FidoFilename(const fa:FidoAdr):string;
begin
  FidoFilename:=FileUpperCase(hex(fa.net,4)+hex(fa.node,4));
end;

function FidoAppendRequestfile(var fa:FidoAdr):string;
var files : string;
    _file : string[30];
    t     : text;
    p,p2  : byte;
    ff    : string[12];
begin
  files:='';
  GetReqFiles(MakeFidoAdr(fa,true),files);
  TrimFirstChar(files, '>');
  ff:=FidoFilename(fa)+'.REQ';
  if files<>'' then begin
    assign(t,ff);
    if existf(t) then append(t)
    else rewrite(t);
    files:=files+' ';
    repeat
      p:=cpos(' ',files);
      if p>0 then begin
        _file:=trim(LeftStr(files,p));
        files:=trimleft(mid(files,p));
        p2:=cpos('/',_file);
        if p2=0 then writeln(t,_file)
        else writeln(t,LeftStr(_file,p2-1)+' !'+mid(_file,p2+1));
        end;
    until p=0;
    close(t);
    end;
  if FileExists(ff) then FidoAppendRequestfile:=ff
  else FidoAppendRequestfile:='';
end;

function CrashFile(adr:string):string;
var fa : FidoAdr;
begin
  splitfido(adr,fa,DefaultZone);
  CrashFile:=FileUpperCase(FidoFilename(fa)+'.cp');
end;

procedure GetReqFiles(adr:string; var files:string);
var

    t     : text;
    s     : string;
begin
  assign(t,ReqDat);
  if existf(t) then begin
    reset(t);
    while not eof(t) do begin
      readln(t,s);
      if s=adr then
        repeat
          readln(t,s);
          TrimFirstChar(s, '>');
          if s<>CrashID then files:=files+' '+s;
        until s=''
      else
        repeat readln(t,s) until s='';
      end;
    close(t);
    files:=trim(files);
    end;
end;


function fstestmark(const s:string; block:boolean):boolean;
begin
  if (LeftStr(s,2)>'  ') and ((s<#176) or (s>#223)) then
    fstestmark:=true
  else begin
    if not block then errsound;
    fstestmark:=false;
    end;
end;

procedure FileSelProc(var cr:customrec);
var s   : string;
    p   : scrptr;
  List: TLister;
begin
  List := TLister.CreateWithOptions(1,ScreenWidth,4,screenlines-fnkeylines-1,-1,'/NS/SB/M/NA/S/APGD/');
  rmessage(2110);   { 'Lade Fileliste ...' }
  List.ReadFromFile(FreqLst,0);
  closebox;
  List.OnTestMark := fstestmark;
  sichern(p);
  repeat
    cr.brk := List.Show;
  until not cr.brk or (List.SelCount=0) or ReadJN(getres(2123),true);   { 'Auswahl verwerfen' }
  holen(p);
  if not cr.brk then begin
    s:= List.FirstMarked;
    while s<>#0 do begin
      s:=trim(s);
      if s[1]>='' then s:=trim(mid(s,2));
      if blankpos(s)>0 then
        s:=LeftStr(s,blankpos(s)-1);
      cr.s:=cr.s+' '+s;
      s:= List.NextMarked;
      end;
    cr.s:=trim(cr.s);
    end;
  List.Free;
end;

function GetFilelist(var fa:fidoadr):string;
var t     : text;
    s     : string[80];
    p     : byte;
    found : boolean;
    node  : string[20];
begin
  GetFilelist:='';
  assign(t,FileLists);
  if existf(t) then begin
    node:=MakeFidoadr(fa,true);
    reset(t);
    found:=false;
    while not found and not eof(t) do begin
      readln(t,s);
      s:=trim(s);
      p:=cpos('=',s);
      if (s<>'') and (s[1]<>'#') and (s[1]<>';') and (p>0) then
        if LeftStr(s,p-1)=node then begin
          found:=true;
          delete(s,1,p);
          if cpos(' ',s)>0 then s:=LeftStr(s,cpos(' ',s)-1);
          getFilelist:=FidoDir+s;
          end;
      end;
    close(t);
    end;
end;

function FidoRequest(node,files:string):string;
var brk   : boolean;
    x,y   : Integer;
    fa    : FidoAdr;
    ni    : NodeInfo;
    atonce: boolean;
    doreq : boolean;
begin
  fidorequest:='';
  if not TestNodelist or not TestDefbox then exit;
  if node='' then fillchar(fa,sizeof(fa),0)
  else SplitFido(node,FA,DefaultZone);
  getFAddress(true,getres(2111),fa,ni,brk,x,y);   { 'File-Request' }
  if brk then exit;
  node:=MakeFidoAdr(fa,true);
  getReqFiles(node,files);
  TrimFirstChar(files, '>');
  atonce:=false;
  maddstring(3,7,getres2(2112,1),files,50,254,'>'); mhnr(735);  { 'Dateien ' }
  freqlst:=GetFilelist(fa);
  if Fileexists(freqlst) then
    MappCustomsel(FileSelProc,false);
  maddbool(4,9,getres2(2112,2),atonce);   { ' sofort starten' }
  readmask(brk);
  enddialog;
  doreq:=(files<>'');
  if not brk then begin
    if not doreq then begin
      message(getres2(2112,3));  { 'Request-Anforderung lschen ...' }
      SetRequest(node,'');
      end
    else begin
      message(getres2(2112,4));   { 'Request-Anforderung speichern ...' }
      SetRequest(node,files);
      end;
    if not atonce then mdelay(500);
    closebox;
    if atonce and doreq then
      fidorequest:=makeFidoAdr(fa,true);
    end;
end;


procedure SetCrash(adr:string; insert:boolean);
var t1,t2   : text;
    s,files : string;
    ni      : NodeInfo;
    fa      : FidoAdr;
begin
  SplitFido(adr,fa,DefaultZone);
  if fa.ispoint then begin     { evtl aus Pointadresse Nodeadresse machen }
    GetNodeinfo(adr,ni,1);
    ShrinkPointToNode(fa,ni);
    if not fa.ispoint then
      adr:=MakeFidoAdr(fa,false);
    end;

  files:='';
  assign(t2,TempFile(''));
  rewrite(t2);
  if Fileexists(ReqDat) then begin
    assign(t1,ReqDat);
    reset(t1);
    while not eof(t1) do begin
      readln(t1,s); s:=trim(s);
      if s=adr then
        repeat
          readln(t1,s); s:=trim(s);
          if (s<>'') and (s<>CrashID) then files:=s;
        until s=''
      else begin
        writeln(t2,s);
        repeat
          readln(t1,s); s:=trim(s);
          writeln(t2,s);
        until s='';
        end;
      end;
    close(t1);
    erase(t1);   { alte ReqDat lschen }
    end;
  if insert or (files<>'') then begin
    writeln(t2,adr);
    if insert then
      writeln(t2,CrashID);
    if files<>'' then writeln(t2,files);
    writeln(t2);
    end;
  close(t2);
  rename(t2,ReqDat);
end;


procedure SetRequest(const adr,files:string);   { '' -> Request lschen }
var t1,t2   : text;
    s       : string;
    crash   : boolean;
    TempFileName: String;
begin
  crash:=false;
  TempFileName := TempFile('');
  assign(t2, TempFileName);
  rewrite(t2);
  if FileExists(ReqDat) then begin
    assign(t1,ReqDat);
    reset(t1);
    while not eof(t1) do begin
      readln(t1,s); s:=trim(s);
      if s=adr then
        repeat
          readln(t1,s); s:=trim(s);
          if s=CrashID then crash:=true;
        until s=''
      else begin
        writeln(t2,s);
        repeat
          readln(t1,s); s:=trim(s);
          writeln(t2,s);
        until s='';
        end;
      end;
    close(t1);
    erase(t1);   { alte ReqDat lschen }
    end;
  if crash or (files<>'') then begin
    writeln(t2,adr);
    if crash then
      writeln(t2,CrashID);
    if files<>'' then writeln(t2,files);
    writeln(t2);
    end;
  close(t2);
  // do not use rename(t2,ReqDat) as of problems under linux
  CopyFile(TempFileName, ReqDat);
  SafeDeleteFile(TempFilename);
end;


{ nl_phone: Nummer im 'Originalzustand', max. 30 Zeichen }

function FidoPhone(var fa:FidoAdr; var nl_phone:string):string;
var ni : NodeInfo;
begin
  GetNodeinfo(MakeFidoAdr(fa,true),ni,2);
  if not ni.found then begin
    nl_phone:='0-0';
    FidoPhone:='???';
    end
  else begin
    nl_phone:=ni.telefon;
    FidoPhone:=FormFidoPhone(ni.telefon);
    end;
end;


{ --- File-Listen --------------------------------------------------- }

procedure ReadFidolist;
var fn     : string;
    brk    : boolean;
    x,y    : Integer;
    node   : string;
    fi,fi2 : string;
    ni     : nodeinfo;
    p      : byte;
    ar     : archrec;
    copied : boolean;
    fa     : FidoAdr;
    arc    : integer;
    useclip: boolean;

label ende;

  function overwrite(fn:string):boolean;
  begin
    overwrite:=ReadJN(LeftStr(fn,40)+getres(2113),true);  { ' bereits vorhanden - berschreiben' }
  end;

  function filetest(docopy:boolean; size:Int64; path:string; fi:string):boolean;
  var
    p       : Integer;
{$IFDEF Linux}
{$IFDEF Kylix}
    fs : TStatFs;
  begin
    statfs(PChar(path),fs);
    if ((int64(fs.f_bavail)*int64(fs.f_bsize))<=size)
{$ELSE}
    fs : statfs;
  begin
    fsstat(path,fs);
    if ((int64(fs.bavail)*int64(fs.bsize))<=size)
{$ENDIF}

{$ELSE}
    driveNr : Integer;
  begin
     driveNr := ord(FirstChar(Path))-64;

    if (diskfree(driveNr)<=size)
{$ENDIF}
                                 and fehlfunc(getres(2114)) then  { 'zu wenig Platz' }
      filetest:=false
    else if docopy and FileExists(path+fi) and not overwrite(path+fi) then
      filetest:=false
    else if ExtractFileExt(fi) = extFl then
      filetest:=true
    else 
    begin
      fi := ChangeFileExt(fi, extFl);
      filetest:=(not FileExists(path+fi) or overwrite(path+fi));
    end;
  end;

  procedure UpdateReqdat;
  var t1,t2 : text;
      s     : string[80];
      p     : byte;
  begin
    rmessage(2115);   { 'Eintrag in Filelisten-Datei..' }
    assign(t2,FidoDir+'reqdat.$$$');
    rewrite(t2);
    writeln(t2,'# ',getres(2116));   { Verzeichnis der Request-Filelisten }
    writeln(t2);
    assign(t1,FileLists);
    if existf(t1) then begin
      reset(t1);
      while not eof(t1) do begin
        readln(t1,s);
        s:=trim(s);
        if (s<>'') and (s[1]<>'#') and (s[1]<>';') then begin
          p:=cpos('=',s);
          if (p>0) and (LeftStr(s,p-1)<>node) and (mid(s,p+1)<>fi2) and
             FileExists(FidoDir+mid(s,p+1)) then   { falsche Eintrge killen }
            writeln(t2,s);
          end;
        end;
      close(t1);
      erase(t1);
      end;
    writeln(t2,node,'=',fi2);
    close(t2);
    rename(t2,FileLists);
    mdelay(200);
    closebox;
  end;

begin
  fn:=FilePath+WildCard;
  useclip:=false;
  if not ReadFilename(getres2(2117,1),fn,true,useclip) or  { 'Fileliste einlesen' }
     (not FileExists(fn) and fehlfunc(getres2(2117,2))) then  { 'Datei nicht vorhanden' }
    goto ende;
  fn:=FileUpperCase(ExpandFileName(fn));
  fi:=ExtractFilename(fn);
  p:=cpos('.',fi);
  if p=0 then fn:=fn+'.';
  if (p>0) and (ival(LeftStr(fi,p-1))>0) then 
  begin
    fillchar(fa,sizeof(fa),0);
    if not Nodelist.Open then
      node:=''
    else begin
      node:=strs(DefaultZone)+':'+strs(ival(LeftStr(fi,4)))+'/'+strs(ival(copy(fi,5,4)));
      getNodeinfo(node,ni,1);
      if not ni.found then
        if FindFidoAddress(fn,fa) then
          node:=MakeFidoAdr(fa,false)
        else
          if ival(FirstChar(fi))>0 then
            node:=FirstChar(fi)+':'+strs(ival(copy(fi,2,3)))+'/'+strs(ival(copy(fi,5,4)))
          else
            node:='';
      end;
    end
  else
    if FindFidoAddress(fn,fa) then
      node:=MakeFidoAdr(fa,false)
    else
      node:='';
  dialog(40,5,getres2(2117,1),x,y);
  maddtext(3,2,getres2(2117,3),0);  { 'Datei' }
  maddtext(10,2,fi,col.coldiahigh);
  maddstring(3,4,getres2(2117,4),node,15,15,nodechar);  { 'Node  ' }
  readmask(brk);
  enddialog;
  if brk or (node='') then goto ende;
  splitfido(node,fa,DefaultZone);
  node:=MakeFidoAdr(fa,true);

  arc:=ArcType(fn);
  if arc<>0 then begin          { gepackte Fileliste }
    OpenArchive(fn,arc,ar);
    if stricmp(ar.name,'FILE_ID.DIZ') then
      ArcNext(ar);
    closearchive(ar);
    if (ar.name='') and fehlfunc(getres2(2117,5)) then goto ende;  { 'Fehler in Archivdatei' }
    if not FileTest(true,ar.orgsize,FidoPath,ar.name) then     goto ende;
    SafeDeleteFile(FidoPath+ar.name);
    if not UniExtract(fn,FidoPath,ar.name) then                goto ende;
    fi:=ar.name;
    copied:=true;
    end
  else if ExtractFilePath(fn)=FidoPath then begin   { ungepackt, in FIDO\ }
    if RightStr(fn,3)<> extFl then
      if not FileTest(false,0,FidoPath,fi) then goto ende;
    copied:=false;
    end
  else begin                                    { ungepackt, woanders }
    if not FileTest(true,_filesize(fn),FidoPath,fi) then goto ende;
    message(getres2(2117,6));  { 'Kopiere Fileliste..' }
    if not filecopy(fn,FidoPath+fi) then begin
      closebox;
      fehler(getres2(2117,7));  { 'Fehler beim Kopieren' }
      goto ende;
      end;
    closebox;
    copied:=true;
    end;
                          
  if ExtractFileExt(fi) <> extFl then 
  begin
    fi2:= ChangeFileExt(fi, extFl);
    SafeDeleteFile(FidoPath+fi2);
    if not RenameFile(FidoPath+fi,FidoPath+fi2) and
       fehlfunc(getres2(2117,8)) then   { 'Fehler beim Umbenennen' }
      goto ende;
    end
  else
    fi2:=fi;
  UpdateReqdat;
  truncstr(fidolastseek,1);
  SaveConfig2;
  if copied and ReadJN(reps(getres2(2117,9),fn),true) then begin  { '%s lschen' }
    message(reps(getres2(2117,10),fn));   { 'Lsche %s ...' }
    _era(fn);
    mdelay(300);
    closebox;
    end;
ende:
  freeres;
end;

procedure DelFidolist;
var cr    : CustomRec;
    t1,t2 : text;
    s     : string[80];
    p     : byte;
    nn    : longint;
    comment: boolean;
begin
  if not FileExists(FileLists) or not FileExists(FidoDir+'*' +extFl) then
    rfehler(2119)   { 'keine Filelisten vorhanden' }
  else begin
    cr.s:='';
    DelFilelist:=true;
    pushhp(85);
    NodeSelProc(cr);
    pophp;
    if cr.brk then exit;
    if ReadJN(reps(getres(2118),cr.s),false) then begin   { 'Fileliste fr %s lschen' }
      rmessage(2119);   { 'Lsche Fileliste ...' }
      nn:=0;
      assign(t1,FileLists); reset(t1);
      assign(t2,FidoDir+'request.$$$'); rewrite(t2);
      while not eof(t1) do begin
        readln(t1,s);
        s:=trim(s);
        p:=cpos('=',s);
        comment:=(s='') or (s[1]='#') or (s[1]=';') or (p=0);
        if comment or (LeftStr(s,p-1)<>cr.s) then begin
          writeln(t2,s);
          if not comment then inc(nn);
          end
        else
          SafeDeleteFile(FidoDir+mid(s,p+1));
        end;
      close(t1); close(t2);
      erase(t1);
      if nn>0 then
        rename(t2,FileLists)
      else
        erase(t2);    { keine Listen brig }
      mdelay(200);
      closebox;
      end;
    end;
end;



{ File Suche in Fido Requstlisten mit bis zu fnf Suchbegriffen  }
function FidoSeekfile:string;
  const
    seekfile         = 'fileseek.dat';
    maxbuf           = 20;
    SearchStr_maxIdx = 4;
    iCase : boolean = true;                 { Gro-Kleinschreibung  }
    wCase : boolean = true;                 { Suche nur ganze Worte }
    _sep             = '/&';                { der Seperator 2-Beyte }

  var
    seek, oldseek    : string;
    sNodInf,sZeile   : string;
    sFlistName       : string;
    sa               : array[0..maxbuf] of string;
    searchStr        : array[0..SearchStr_maxIdx] of string;
    x,y              : Integer;
    brk              : boolean;
    pFileListCfg     : text;
    pOutput          : text;
    pFileListe       : text;
    anz_FileFound, p : longint;
    tb               : pointer;
    scp              : scrptr;
    tbs              : word;
    ni               : ^nodeinfo;
    files            : string;
    len              : byte;
    anz_searchStr    : integer;    { Anzahl der besetzten Suchstrings }
    List: TLister;
    label
       ende;

 {true, wenn der Substring in dem zu durchsuchenden String vollstndig enthalten ist }
 { _pos= die Startposition des Vorhandenen SubStrings!!! }
  function fInStr( var SubStr: string; var s : string; var _pos: integer) :boolean;
  begin
    fInStr:=false;                      { Funktionswert false initialisieren }
    if  _pos > 1  then                  { String nicht zu Beginn des Suchstringes und }
      if s[ _pos-1] <>' '  then exit;   { Zeichen vor dem Stringbegin <> space}

    if _pos+length(Substr) <= length(s) then  { Suchbegriff nicht am Ende des Stringes }
      if (s[_pos+length(Substr)] <> ' ') then exit;

    { Alle Tests bestanden }
    fInStr:=true;
  end;
  procedure pTestWriteln(const s:string);
  begin
    writeln(pOutput,s);
    if IOResult<>0 then begin
      fehler(ioerror(ioresult,getres2(2120,1)));   { 'Schreibfehler' }
      brk:=true;
     end;
  end;

  procedure pTabExpand(var ss:string);
   const TAB = #9;
   var p : byte;
  begin
    p:=cpos(TAB,ss);
    while p>0 do begin
      delete(ss,p,1);
      insert(sp(8-(p-1) mod 8),ss,p);
      p:=cpos(TAB,sNodInf);
      end;
  end;

  {teste den Suchstring auf Korrektheit}
  procedure pTestSeekStr( var fidolastseek: string );
  begin
    if ( pos(_sep,fidolastseek) = 1 ) then
    begin
      fidolastseek:=copy(fidolastseek,3,500 );
    end;
  end;

  {zerlege Suchstring }
  procedure pInitSearchStr;
  var
    _pos    : integer;
    tempStr : string[50];
  begin
    anz_searchStr:=0;
    tempStr:=seek;
    while ( tempStr <> '') and ( anz_searchStr <= SearchStr_maxIdx) Do
    begin
      searchStr[anz_searchStr]:=tempStr;   { (Rest)-String -> Suchbegiff }
      inc(anz_searchStr);                  { noch ein Suchbegriff }
      _pos:=pos(_sep, tempStr);
      if _pos=0 then exit;                 { kein Seperator mehr gefunden -> raus}
      searchStr[anz_searchStr-1]:=copy(searchStr[anz_searchStr-1],1,_pos-1); {String abschneiden}
      tempStr:=copy(tempStr,_pos+length(_sep),500); {String abschneiden}
    end;
  end;

  {sind die Suchbegriffe im Dateibeschreibungsblock vorhanden }
  procedure pTestBlock( BlockLength :integer );
    var
      n, nn, n2, _pos  : integer;
      test : boolean;
      sZeile           : string;
      sSub             : string;
  begin
    test := false;
    for n2:=0 to anz_searchStr - 1 Do     { nach alle Begriffen durchsuchen }
    begin
      n:=0;
      test:=false;
      if  icase  then  sSub:=UpperCase(searchStr[n2])
      else             sSub:=searchStr[n2];
      { alle Zeilen auf ein Suchbegriff durchsuchen durchtesten }
      while ( n < BlockLength ) and (test=false)  do
      begin
        if  icase then sZeile:=UpperCase(sa[n])
        else           sZeile:=sa[n];
        _pos:=pos( sSub, sZeile );
        if _pos  > 0 then   { SubSting in der Beschreibung vorhanden}
        begin
          if wCase = false then  test:=true         { ignore, Ganzes Wort}
          else test:=fInStr( sSub, sZeile, _pos );  { noch auf ganzes Wort testen }
        end;
        inc(n);                                     { nchste Zeile }
      end; { while ( n < apos)   do } { alle Zeilen durchtesten }
      {Begriff im Bolck nicht gefunden, dann raus }
      if test =false then exit;
    end;    { for n2:=0 to anz_searchStr - 1 Do }

    if test = true then
    begin
      { schreibe 1. Zeile und die node Nummer }
      pTestWriteln(forms(sa[0],80)+LeftStr(sNodInf,p-1));
      nn:=1;
      while ( nn < BlockLength) and ( brk = false )   do
      begin
        pTestWriteln(sa[nn] ); {Zeile des Blockes speichern }
        inc(nn);
      end;
      inc(anz_FileFound);      {Erhhe Anzahl der gefunden  }
      mwrt(x+13,y+3,strsn(anz_FileFound,5));
    end;
    if KeyPressed then
       brk:= ReadKey = #27;
  end;      { function testBlock :boolean;}

  procedure pBearbeiteFileListe;
  var
     apos           : integer;
     beginSafe      : boolean;
  begin
    attrtxt(col.colmboxhigh);
    mwrt(x+13,y+2,forms(mid(sNodInf,p+1),12));  { Dateiname anzeigen }
    getNodeinfo(LeftStr(sNodInf,p-1),ni^,1);
    settextbuf(pFileListe,tb^,tbs);
    reset(pFileListe);
    begin                                  { write header}
      sNodInf:=LeftStr(sNodInf,p-1)+' ';      { s:= 2:244/1278 }
      if ni^.found then sNodInf:=sNodInf+'('+ni^.boxname+', '+ni^.standort+', '+sFlistName  +')'
      else sNodInf:=sNodInf+'(??, '+sFlistName  +')';         { s:= 2:244/1278 (C-Box, Frankfurt, 02441278.FL}
      writeln(pOutput,' ',' '+sNodInf);
      writeln(pOutput,' ',' '+typeform.dup(length(sNodInf),''));
      writeln(pOutput);
    end;
    apos:=0;                                    { Zeilenzhler ungltig setzen}
    beginSafe:=false;
    while not eof(pFileListe) and (not brk) do               {'FIDO\22441278.fl'}
    begin
      readln(pFileListe,sZeile);               {lese Zeile aus der Fileliste }
      pTabExpand(sZeile);
      { ist gelesene Zeile eine headerzeile }
      if ( FirstChar(sZeile) >' ') and( sZeile <> '') and (( FirstChar(sZeile) <#176)or( FirstChar( sZeile) >#223)) then
      begin
        beginSafe:=true;
        if( apos > 0 ) then { wurde ein Block bereits zwischengespeichert?}
        begin
          { Block testen und ggf. speichern }
          pTestBlock( apos );
          apos:=0;  { setze ZeilenZhler auf Start }
        end;
      end; { if (ss[1]>' ') and ( (ss[1]<#176)or( ss[1]>#223) ) then }
      if ( apos <= maxbuf) and  ( beginSafe ) then { im gltigen Bereich}
      begin
        sa[apos]:=sZeile;  { speicher String in Array }
        inc(apos);
      end;
    end; { while not eof(pFileListe^) do begin}
    close(pFileListe);
  end;


begin       { FidoSeekfile:string;************************ }
  FidoSeekfile:='';
  anz_FileFound:=0;                     { Anzahl der gefunden Dateien =0 }
  if not FileExists(FileLists) or not FileExists(FidoDir+'*' + extFl) then
  begin
    fehler(getres2(2120,2));            { 'keine Filelisten vorhanden' }
    goto ende;
  end;
  oldseek:=fidolastseek;                { icase+letzten Suchstring  }
  fidolastseek:=mid(fidolastseek,3);    { icase extrahieren }
  iCase:=(FirstChar(oldseek)='J');         { icase     }
  wCase:=(copy(oldseek,2,1)='J');       { Wcase     }
  {Anzeige initilisieren }
  dialog(57,6,getres2(2120,3),x,y);     { 'Dateien suchen' }
  if LastChar(fidolastseek)=#27 then
     fidolastseek:=LeftStr(fidolastseek, length(fidolastseek)-1);
  maddstring(3,2,getres2(2120,4),fidolastseek,40,40,'');   { 'Suchbegriff ' }
  maddbool(3,4,getres2(2120, 5),iCase); { 'Schreibweise ignorieren' }
  maddbool(3,5,getres2(2120,11),wCase); { 'Nur ganze Wrter suchen }
  readmask(brk);                        {  Dialog anzeigen/ausfhren }
  enddialog;
  pTestSeekStr( fidolastseek);           {teste den String auf Korrektheit}
  fidolastseek:=iifc(icase,'J','N')+iifc(Wcase,'J','N')+fidolastseek; {Ja or Nein + Suchbegriff }

  if brk or (fidolastseek='') then goto ende;

  if icase then seek:=UpperCase(mid(fidolastseek,3)) {seek, enthlt nun den suchstring}
  else          seek:=mid(fidolastseek,3);
  pInitSearchStr;                       { zerlege Suchstring}

  if fidolastseek <> oldseek  then
  begin
    msgbox(30,6,getres2(2120,6),x,y);   { 'Suchen ..' }
    mwrt(x+3,y+2,getres2(2120,7));      { 'Datei' }
    mwrt(x+3,y+3,getres2(2120,8));      { 'gefunden' }
    new(ni);
    tbs:=16384;
    getmem(tb,tbs);
    assign(pOutput,seekfile);
    rewrite(pOutput);
    len:=length(getres2(2120,9))+3;
    writeln(pOutput,' ',' '+typeform.dup(len+length(seek),''));
    writeln(pOutput,' ',' '+getres2(2120,9),' "',mid(fidolastseek,3),'"');   { 'Dateisuche nach' .. }
    writeln(pOutput,' ',' '+typeform.dup(len+length(seek),''));
    writeln(pOutput);
    assign(pFileListCfg,FileLists);
    reset(pFileListCfg);
    while ( not eof(pFileListCfg)) and (not brk) do       {noch Eintrge in der cfg.datei}
    begin
      readln(pFileListCfg,sNodInf); sNodInf:=trim(sNodInf);
      p:=cpos('=',sNodInf);
      if (sNodInf<>'') and (FirstChar(sNodInf)<>'#') and (FirstChar(sNodInf) <>';') and (p>0) then
      begin
        sFlistName:= UpperCase(mid(sNodInf,p+1));        { Name der Fileliste z.B: 22441278.fl}
        assign(pFileListe,FidoDir+sFlistName  );    { pFileListe='FIDO\22441278.fl'}
        if existf(pFileListe) then
          pBearbeiteFileListe;
      end;
    end;
    saveconfig2;
    xp1.signal;
    close(pFileListCfg);
    close(pOutput);
    if brk then
    begin
      erase(pOutput);
      fidolastseek:=fidolastseek+#27;
    end;
    if IoResult<>0 then;
    closebox;
    freemem(tb,tbs);
    dispose(ni);
  end;               { fidolastseek<>oldseek }
  if not brk then    { gefundene Dateien Listen und ggf. requesten }
  begin
    List := TLister.CreateWithOptions(1,ScreenWidth,4,screenlines-fnkeylines-1,-1,'/NS/SB/M/NA/S/NLR/APGD/');
    List.ReadFromFile(seekfile,0);
    List.OnTestMark := fstestmark;
    List.OnKeypressed := listext;                { 'D' + 'W' }
    llh:=false; listmakros:=0;
    sichern(scp);
    pushhp(83);
    brk := List.Show;
    pophp;
    holen(scp);
    files:='';
    sNodInf:= mid(List.FirstMarked,81);;
    sZeile:=List.FirstMarked;
    while (sZeile<>#0) do
    begin
      if mid(sZeile,81)<>sNodInf then  { Request bei zwei Boxen! }
      begin
        fehler(getres2(2120,10));      { 'kein gleichzeitiger Request bei mehreren Boxen mglich' }
        sZeile:=#0;                    { Schleife abbrechen }
      end
      else
      begin
       files:=files+' '+trim(LeftStr(sZeile,12));
       sZeile:=List.NextMarked;
      end;
    end;
    files:=trim(files);
    if files<>'' then
    begin
      keyboard(keycr);
      FidoSeekfile:=FidoRequest(sNodInf,files);
    end;
    List.Free;
  end;
ende:
  freeres;
end;

function FidoIsISDN(const fa:FidoAdr):boolean;
var ni : NodeInfo;
begin
  GetNodeInfo(MakeFidoAdr(fa,true),ni,2);
  result:=(pos('ISDN',ni.fflags)>0) or
          (pos('X75',ni.fflags)>0);
end;

function FidoIsBinkP(var fa:FidoAdr):string;
var ni : NodeInfo;
begin
  GetNodeInfo(MakeFidoAdr(fa,true),ni,2);
  if pos('IBN',ni.fflags)>0 then
    result:=ni.boxname
  else
    result:='';
end;


{ In Textfile nach erster brauchbarer Nodeadresse suchen }

function FindFidoAddress(const fn:string; var fa:FidoAdr):boolean;
var t    : text;
    s    : string;
    n    : byte;
    found: boolean;
    p,p2 : integer;
begin
  FindFidoAddress := false;
  assign(t,fn);
  if not existf(t) then exit;
  reset(t);
  n:=0;
  found:=false;
  while (n<100) and not found and not eof(t) do begin
    readln(t,s);
    p:=cpos(':',s);
    while (p>1) and not found do begin
      p2:=p+1;
      while (p2<length(s)) and isnum(s[p2]) do   { Ende der Netznummer suchen }
        inc(p2);
      if s[p2]='/' then begin
        found:=true;
        while (p>1) and isnum(s[p-1]) do    { Anfang der Zonennummer suchen }
          dec(p);
        inc(p2);
        while (p2<length(s)) and isnum(s[p2+1]) do
          inc(p2);                          { Ende der Nodenummer suchen }
        s:=copy(s,p,p2-p+1);
        end
      else begin
        s:=mid(s,p2);
        p:=cpos(':',s);
        end;
      end;
    inc(n);
    end;
  close(t);
  if found then SplitFido(s,fa,DefaultZone);
  FindFidoAddress:=found;
end;

end.
