{   $Id: xpfidonl.pas 7021 2005-10-04 08:15:20Z mkaemmerer $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ Nodelisten-Konfiguration; Diffs verarbeiten }

{$I xpdefine.inc}

unit xpfidonl;

interface

uses  classes,sysutils,typeform,montage,fileio,maske,resource,archive,
      xp0,xp1,xp1o,xpglobal,fidoglob;


procedure InitNodelist;
procedure EditNLentry(var NLItem: TNodeListItem; var brk:boolean);
function  NewNodeEntry:boolean;

function  DoDiffs(const files:string; auto:boolean):byte;
procedure ManualDiff;

function  setfnlenable(var s:string):boolean;


implementation  { --------------------------------------------------- }

uses
{$IFDEF Kylix}
  xplinux,
{$ENDIF}   
  xpfido, ndiff, debug;


{ --- Nodelisten-Konfiguration laden/speichern ---------------------- }

procedure InitNodelist;
var
    indexflag : boolean;
    i         : integer;
    xni       : boolean;

  procedure NL_Datecheck;      { testen, ob neue Liste dazugekommen }
  var
      fh: Integer;
  begin
    if FileDateToDateTime(FileAge(NodeListCfg)) > FileDateToDateTime(FileAge(UserIndexF)) then
    begin
      if FileDateToDateTime(FileAge(NodeListCfg))> now then
      begin
{$IFDEF Kylix}
        FileSetDate(NodeListCfg, DateTimeToFileDate(now));
{$ELSE}
        fh := FileOpen(NodeListCfg, fmOpenReadWrite);
        FileSetDate(fh, DateTimeToFileDate(now));
        FileClose(fh);
{$ENDIF}
      end;
      indexflag:=true;
    end;
  end;

begin           //procedure InitNodelist;
  NodeList := TNodeList.Create;
  NodeList.LoadConfigFromFile;          { Nodelist-Konfiguration im neuen Format laden }
  indexflag:=false;                     { altes Format wird nicht mehr untersttzt                    }

  for i:=0 to NodeList.Count - 1 do
    if not FileExists(FidoDir+NodeList.GetFilename(i)) then
      trfehler1(214,FidoDir+NodeList.GetFilename(i),10);  { 'Node-/Pointliste %s fehlt!' }
  if NodeList.Count > 0 then
  begin
    xni:=FileExists(NodeIndexF);                //exists 'FIDO\NODELIST.IDX'
    if xni then NL_Datecheck;
    if indexflag or not xni or not FileExists (UserIndexF) then
      MakeNodelistIndex;
    OpenNodeindex(NodeIndexF);
    if xni and not FileExists(NodeIndexF) then begin  { gelscht durch OpenNodeindex }
      MakeNodelistIndex;
      OpenNodeindex(NodeIndexF);
      end;
    end
  else
    Nodelist.Open:=false;    //mOpen wird von procedure OpenNodeindex ggf. auf true gesetzt
end;



{ --- Nodelisten-Konfiguration bearbeiten (s. auch XP10) ------------ }

var  fne_first : integer;


function setfnlenable(var s:string):boolean;
var i : integer;
begin
  setfnlenable := true;     { MK 14.02.00 Standard-Wert setzen }
  if (s='') or (length(s)=1) then
    for i:=fne_first to fne_first+2 do
      setfieldenable(i,s<>'');
end;


procedure EditNLentry(var NLItem: TNodeListItem; var brk:boolean);
var x,y,i    : Integer;
    filechar : string;
    lform    : string;
    adresse  : string;
    fa       : fidoadr;
begin
  dialog(ival(getres2(2127,0)),14,getres2(2127,2),x,y);
  with NLItem do
  begin
    filechar:='>'+range('#','~')+'!';
    maddtext(3,2,getres2(2127,5),0);                    // 'Listenname      '
    maddtext(21,2,listfile,col.coldiahigh);
    maddtext(39,2,getres2(2127,6),0);                   // 'Nummer '
    maddtext(47,2,formi(number,3),col.coldiahigh);
    lform:=getres2(2128,format);
    maddstring(3,4,getres2(2127,7),lform,15,20,'');     // 'Listenformat
    mhnr(940);
    for i:=1 to res2anz(2128) do
      mappsel(true,getres2(2128,i));
    case format of
      1     : if zone=0 then adresse:=''
              else adresse:=strs(zone);
      2,4   : adresse:=strs(zone);
      3     : adresse:=strs(zone)+':'+strs(net)+'/'+strs(node);
      5     : adresse:='';
      end;
    maddstring(3,5,getres2(2127,8),adresse,15,15,'0123456789:/');
    maddstring(3,7,getres2(2127,9),fupdatefile,12,12,filechar);          //'Update-Datei   '
    mset1func(setfnlenable);
    maddstring(3,8,getres2(2127,10),fupdatearc,12,12,filechar);          // 'Update-Archiv  ' }
    maddstring(3,10,getres2(2127,11),fprocessor,28,40,'');               // 'bearbeiten durch' }
      if fupdatefile='' then mdisable;
      fne_first:=fieldpos;
    maddbool(3,12,getres2(2127,12),fdodiff);                             // 'Update als Diff einbinden'
      if fupdatefile='' then mdisable;
    maddbool(3,13,getres2(2127,13),fdelupdate); { 'Update nach Einbinden lschen' }
      if fupdatefile='' then mdisable;
    readmask(brk);
    if not brk then
    begin
      for i:=1 to res2anz(2128) do
        if UpperCase(lform)=UpperCase(getres2(2128,i)) then
          format:=i;
      if format in [nlNodelist,nlPoints24,nl4DPointlist] then
        zone:=ival(adresse)
      else begin
        Splitfido(adresse,fa,defaultzone);
        zone:=fa.zone; net:=fa.net; node:=fa.node;
        end;
      if fupdatefile='' then fDoDiff:=false;
      end;
    end;
  enddialog;
  freeres;
end;


function NewNodeEntry:boolean;
var fn      : string;
    ffn     : string[12];
    brk     : boolean;
    useclip : boolean;
    i       : integer;
    NLItem  : TNodeListItem;
    p       : byte;
    detect  : boolean;
    arc     : integer;
    ar      : ArchRec;
    fa      : FidoAdr;

  procedure PL_FormatDetect(const fn:string; var format:byte);
  var t   : text;
      s   : string;
      n   : byte;
  begin
    if FileExists(fn) then
    begin
      Assign(t, fn);
      reset(t);
      n:=0;
      while (format=1) and (n<200) and not eof(t) do begin
        readln(t,s);
        if LeftStr(s,5)='Boss,' then
          format:=nlFDpointlist
        else if LeftStr(s,6)='Point,' then begin
          format:=nl4Dpointlist;
          NLItem.zone:=DefaultZone;
          end;
        inc(n);
        end;
      close(t);
      end;
  end;

begin   //function NewNodeEntry:boolean;
  NewNodeEntry:=false;
  fn:=WildCard;
  useclip:=false;        { 'Neue Node-/Pointliste einbinden' }
  pushhp(931);
  if ReadFilename(getres2(1019,10),fn,true,useclip) then
    if not FileExists(fn) then
      rfehler(22)        { 'Datei ist nicht vorhanden! }
    else begin
      NLItem:=TNodeListItem.Create;
      arc:=ArcType(fn);
      if arc>0 then begin          { gepackt -> Dateiname aus Archiv auslesen }
        ar.name:='';
        OpenArchive(fn,arc,ar);
        if stricmp(ar.name,'FILE_ID.DIZ') then
          ArcNext(ar);
        ffn:=FileUpperCase(ar.name);
        if ffn='' then ffn:=ExtractFilename(fn); { getfilename(fn);}
        CloseArchive(ar);
        end
      else
        ffn:=ExtractFileName(fn); {getfilename(fn);}
      i:=0;
      while (i<NodeList.Count) and (ffn<>NodeList.GetFilename(i)) do
        inc(i);
      if i<NodeList.Count then
        rfehler(1009)   { 'Diese Node-/Pointliste ist bereits eingebunden' }
      else
      with NLItem do
        if (arc=0) or UniExtract(fn,OwnPath+FidoDir,ffn) then
        begin
          if arc>0 then                                { ggf. entpacken }
            fn:=OwnPath+FidoDir+ffn;
          listfile:=ffn;
          p:=cpos('.',listfile);
          if (p>0) and isnum(mid(listfile,p+1)) then begin
            number:=ival(mid(listfile,p+1));
            listfile:=LeftStr(listfile,p)+'###';
            fDoDiff:=true;
            end;
          format:=nlNodelist;                           { Nodelist }
          detect:=false;
          if listfile='NODELIST.###' then begin         { Typvorgabe 'Nodeliste' }
            fupdatefile:='NODEDIFF.###';
            fupdatearc:='NODEDIFF.Z##';
            detect:=true;
            end
          else if listfile='POINTS24.###' then begin    { Typvorgabe 'Points24' }
            fupdatefile:='PR24DIFF.###';
            fupdatearc:='PR24DIFF.Z##';
            zone:=2;
            format:=2;
            detect:=true;
            end
          else if ExtractFileExt(listfile)='.PVT' then begin { Typvorgabe 'PVT-Liste' }
            fupdatefile:=listfile;
            format:=3;
            if FindFidoAddress(fn,fa) then begin
              zone:=fa.zone; net:=fa.net; node:=fa.node;
              detect:=true;
              end;
            fDelUpdate:=true;
            end
          else
            PL_FormatDetect(fn,fformat);
          if not detect then
            EditNLentry(NLItem,brk)
          else
            brk:=false;
          if not brk then
            if (ExtractFilePath(fn)=OwnPath+FidoDir) or
               filecopy(fn,FidoDir+Extractfilename(fn)) then
            begin
              NodeList.Add(NLItem);
              if listfile='NODELIST.###' then
                ShrinkNodelist(false);
              NewNodeEntry:=true;
            end;
          end;
        end;
  pophp;
  freeres;
end;    //function NewNodeEntry:boolean;


function ReplNr(const fn:string; number:integer):string;
var
  p : Integer;
begin
  p:=pos('###',fn);
  if p>0 then
    ReplNr:=LeftStr(fn,p-1)+formi(number,3)+mid(fn,p+3)
  else
  begin
    p:=pos('##',fn);
    if p>0 then
      ReplNr:=LeftStr(fn,p-1)+formi(number mod 100,2)+mid(fn,p+2)
    else
      ReplNr:=fn;
  end;
end;


{ Im FILES- und TICK-Verzeichnis Diff/Update-Files fr alle   }
{ eingetragenen Nodelisten suchen und ausfhren.              }

{ Files = Pfad + Name/Wildcard der Datei(en), die eingebunden }
{         werden sollen                                       }
{                                                             }
{ Ergebnis:  0 = ok                                           }
{            1 = Fehler                                       }
{            2 = Update ist bereits eingebunden               }

{ Bei Update-Files mit fortlaufender Nummer versucht XP, die  }
{ nchsten vier Updates einzubinden.                          }

function  DoDiffs(const files:string; auto:boolean):byte;
var diffdir  : string;
    diffnames: string;
    i        : integer;
    newlist  : string;
    uarchive : string;
    ufile    : string;
    nextnr   : integer;
    unarcflag: boolean;
    done     : boolean;
    reindex  : boolean;
    logfile  : text;
    logopen  : boolean;
    TmpDoDiff: boolean;
    ucount   : byte;     { Zhler fr Update-Files mit Nummern }

  procedure log(const txt:string);
  begin
    if not logopen then begin
      assign(logfile,LogPath+'NODELIST.LOG');
      if existf(logfile) then append(logfile)
      else rewrite(logfile);
      writeln(logfile);
      logopen:=true;
      end;
    writeln(logfile,LeftStr(date,6),RightStr(date,2),' ',time,'  ',txt);
  end;

  function NextNumber(number:integer):integer;
  begin
    NextNumber:=(number+6) mod iif(schaltj(ival(RightStr(date,4))-1),366,365) + 1;
  end;

  procedure ExpandFilePath(var s:string);
  begin
    if s<>'' then
      if FileExists(diffdir+s) then
        s:=diffdir+s
      else if (diffdir=FilePath) and FileExists(FilePath+'TICK\'+s) then
        s:=FilePath+'TICK\'+s
      else
        s:='';
  end;

  function passend(const fn:string):boolean;
  begin
    passend:=(diffnames=WildCard) or (FileUpperCase(ExtractFilename(fn))=FileUpperCase(diffnames));
  end;

  procedure ExecProcessor(processor:string);
  var p : byte;
  begin
    p:=pos('$FILE',UpperCase(processor));
    if p>0 then
      processor:=LeftStr(processor,p-1)+ufile+mid(processor,p+5);
    log(processor);
    shell(processor,600,1);
  end;

  function UDiff:boolean;      { Update diffen }
  var s1,s2 : string;
      t     : text;
      fm    : byte;
  begin
    UDiff:=false;
    if not FileExists(FidoDir+NodeList.GetFilename(i)) then exit;
    fm:=filemode; filemode:= fmOpenRead + fmShareDenyWrite;
    assign(t,FidoDir+NodeList.GetFilename(i));          { 1. Zeile vergleichen }
    reset(t); readln(t,s1); close(t);
    assign(t,ufile);
    reset(t); readln(t,s2); close(t);
    filemode:=fm;
    if s1<>s2 then begin
      trfehler1(2111,NodeList.GetFilename(i),30);   { '%s: Falsche Version von Nodelist oder Nodediff' }
      log(getreps2(2130,3,NodeList.GetFilename(i)));   { dito }
      exit;
      end;
    chdir(fidodir_);
    UDiff:=true;
    log(NodeList.GetFilename(i)+' + '+ufile+' -> '+extractfilename(newlist));
    try
      Processlist(NodeList.GetFileName(i), ufile);
    except
      arfehler(2112,auto);    { 'Fehler beim Bearbeiten der Node-/Pointdiff' }
      log(getres2(2130,4));   { dito }
      UDiff:=false;
    end;
    chdir(ownpath);
  end;

  function CopyUpdateFile:boolean;    { Update kopieren }
  begin
    TmpDoDiff := false;
    CopyUpdateFile:=false;
    if (filetime(newlist)<>filetime(ufile)) or
       (_filesize(newlist)<>_filesize(ufile)) then
      if diskfree(0)+_filesize(NodeList.GetFilename(i)) < _filesize(ufile)+8192 then begin
        arfehler(2113,auto);  { 'Zu wenig Plattenplatz zum Kopieren des Nodelist-Updates' }
        log(getreps2(2130,5,extractfilename(ufile)));  { 'Zu wenig Plattenplatz zum Kopieren von %s' }
        end
      else begin
        SafeDeleteFile(newlist);
        log(ufile+' -> '+newlist);
        if filecopy(ufile,newlist) then
          CopyUpdateFile:=true
        else
          log(getreps2(2130,6,ufile));     { 'Fehler beim Kopieren von %s' }
        end
    else
      TmpDoDiff := true;
  end;

begin   //function  DoDiffs(files:string; auto:boolean):byte;
  Debug.DebugLog('xpfidonl', 'Starting DoDiffs in ' + files, dlInform);
  DoDiffs:=1;
  reindex:=false;
  logopen:=false;
  diffdir:=ExtractFilePath(files);
  diffnames:=ExtractFilename(files);

  for i:=0 to NodeList.Count - 1 do
  with TNodeListItem(Nodelist.Items[i]) do
  begin
    ucount:=5;
    nextnr:=number;
    repeat
      done:=false;
      nextnr:=NextNumber(nextnr);
      newlist:=FidoDir+ReplNr(listfile,nextnr);   { Dateinamen expandieren }
      uarchive:=ReplNr(fupdatearc,nextnr);
      ufile:=ReplNr(fupdatefile,nextnr);
      ExpandFilePath(uarchive);
      unarcflag:=false;                           { Update-Archiv auspacken }
      Debug.DebugLog('xpfidonl', 'NextNumber' + IntToStr(nextnr) + ' uarchive: ' + uarchive + ' ufile: ' + ufile, dlDebug);
      if (uarchive<>'') and passend(uarchive) then
      begin
        Debug.DebugLog('xpfidonl', 'Using ' + uarchive, dlDebug);
        SafeDeleteFile(diffdir+ufile);
        log(getreps2(2130,1,ufile + ' from ' + uarchive));      { 'entpacke %s' }
        unarcflag:=UniExtract(uarchive,diffdir,ufile);
        if not unarcflag then
          log(getres2(2130,2));              { 'Fehler beim Entpacken' }
        diffnames:=WildCard;
        end;
      ExpandFilePath(ufile);
      if FileExists(ufile) and passend(ufile) then
      begin
        if fprocessor<>'' then
          ExecProcessor(fprocessor);
        Debug.DebugLog('xpfidonl', 'Using ' + ufile, dlDebug);
        if fDoDiff and UDiff then begin       { Update diffen }
          number:=nextnr;
          NodeList.SaveConfigToFile;
          done:=true;
          if listfile='NODELIST.###' then
            ShrinkNodelist(false);
          end;
        if not fDoDiff and CopyUpdateFile then
        begin    { Update kopieren }
          if pos('##',listfile)>0 then begin
            _era(FidoDir+NodeList.GetFilename(i));      { alte Liste lschen }
            number:=nextnr;
            NodeList.SaveConfigToFile;
            end;
          done:=true;
          end;
        if TmpDoDiff then DoDiffs := 2; { MK 01/00 Workaround TMT }
        if unarcflag then _era(ufile);
        end;
      if done then begin
        if auto and fDelUpdate then begin    { evtl. Update-Files lschen }
          SafeDeleteFile(uarchive);
          SafeDeleteFile(ufile);
          end;
        reindex:=true;
        end;
      if done then DoDiffs:=0;
      dec(ucount);
    until (pos('##',listfile)=0) or (not done and (fdodiff or (ucount=0)));
    end;

  freeres;
  if logopen then close(logfile);
  if reindex then begin
    if Nodelist.Open then CloseNodeIndex;
    MakeNodelistindex;
    OpenNodeindex(NodeIndexF);
    end;
end;


procedure ManualDiff;
var fn      : string;
    useclip : boolean;
begin
  fn:=FilePath + WildCard;
  useclip:=false;
  if ReadFilename(getres(1020),fn,true,useclip) then   { 'Node-/Pointlist-Update einbinden' }
    if not FileExists(fn) then
      rfehler(22)     { 'Datei ist nicht vorhanden!' }
    else
      case DoDiffs(fn,false) of
        1 : rfehler(1010);    { 'Datei konnte nicht als Node-/Pointlist-Update eingebunden werden.' }
        2 : rfehler(2124);    { 'Diese Datei ist bereits eingebunden.' }
      end;
end;

initialization
  NodeList := nil;
finalization
  if Assigned(NodeList) then
  begin
    NodeList.ClearItems;
    NodeList.Free;
  end;

end.
