{   $Id: xpkeys.pas 7015 2005-10-02 10:09:19Z mkaemmerer $

    Copyright (C) 1991-2001 Peter Mandrella
    Copyright (C) 2000-2002 OpenXP team (www.openxp.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ (Funktions)tasten & Makros }

{$I xpdefine.inc }

unit xpkeys;

interface

uses
  xpglobal,sysutils,typeform,fileio,inout,keys,resource,xp0,xp1;


type  getf_func   = function(nr,nn:byte):string;
var   getfilename : getf_func;
const FuncExternal: boolean = false;    { *-Funktionen gesperrt }
      PreExtProc  : procedure = nil;


procedure prog_call(nr,nn: integer);
function  test_fkeys(var t:taste):boolean;
procedure Xmakro(var t:taste; flags:byte);


const k0_S  : char = 'S';      { Spezial-Mode         }
      k0_A  : char = 'A';      { Alle Bretter         }
      k0_H  : char = 'H';      { Brett hinzufgen     }
      k0_cH : char = ^H;       { aus Maps-Liste anlg. }
      k0_L  : char = 'L';      { Brett lschen        }
      k0_E  : char = 'E';      { Brett editieren      }
      k0_V  : char = 'V';      { Bretter verknpfen   }
      k0_cT : char = ^T;       { Trennzeile einfgen  }
      k0_P  : char = 'P';      { Bretter verschieben  }
      k0_Le : char = 'L';      { Lesemode setzen      }
      k0_B  : char = 'b';      { Brettbrief           }
      k0_SB : char = 'B';      { Brett-Crossposting   }
      k0_I  : char = 'I';      { Binrdatei senden    }
      k0_TE : char = 'E';      { Textdatei senden     }
      k0_cG : char = ^G;       { Brettgruppe mark.    }
      k0_cE : char = ^E;       { Bretter entmark.     }
      k0_cW : char = ^W;       { Brettweiterschalter  }
      k0_cF : char = ^F;       { Satznummer           }
      k0_Ac : char = 'A';      { Spezial / Zugriff    }

      k1_S  : char = 'S';      { Spezialmode          }
      k1_O  : char = 'O';      { Sortier-Umschalter   }
      k1_H  : char = 'H';      { User hinzufgen      }
      k1_V  : char = 'V';      { Verteiler anlegen    }
      k1_L  : char = 'L';      { User lschen         }
      k1_E  : char = 'E';      { User editieren       }
      k1_cV : char = ^V;       { Userbretter verkn.   }
      k1_B  : char = 'b';      { Userbrief            }
      k1_SB : char = 'B';      { User-Crossposting    }
      k1_I  : char = 'I';      { Binrdatei senden    }
      k1_TE : char = 'E';      { Textdatei senden     }
      k1_R  : char = 'R';      { Adrebuch ein/austr. }
      k1_P  : char = 'P';      { Pawort ndern       }
      k1_cE : char = ^E;       { User entmarkieren    }
      k1_cW : char = ^W;       { Userweiterschalter   }
      k1_U  : char = 'U';      { Usersuche            }
      k1_A  : char = 'A';      { Adrebuch-Umschalter }

      k2_S  : char = 'S';      { Spezial-Men         }
      k2_cR : char = ^R;       { Rot13                }
      k2_cH : char = ^H;       { Hex-Dump             }
      k2_I  : char = 'I';      { Info-Fenster         }
      k2_O  : char = 'O';      { Originalheader       }
      k2_H  : char = 'H';      { Halten               }
      k2_L  : char = 'L';      { Lschen              }
      k2_K  : char = 'K';      { Kill                 }
      k2_cU : char = ^U;       { UserEdit             }
      k2_V  : char = 'V';      { Wiedervorlage        }
      k2_cE : char = ^E;       { Nachrichten entmark. }
      k2_U  : char = 'U';      { User-Fenster         }
      k2_cF : char = ^F;       { Textdatei senden     }
      k2_cI : char = ^I;       { Binrdatei senden    }
      k2_G  : char = 'G';      { Bezugssuche          }
      k2_cA : char = ^A;       { Fido-Anzeige umsch.  }
      k2_KA : char = 'A';      { Adreanzeige im Baum }
      k2_EA : char = 'A';      { Empfngeranzeige     }
      k2_cW : char = ^W;       { Weiterschalter       }
      k2_cD : char = ^D;       { Datumsanzeige        }
      k2_R  : char = 'R';      { Drucken              }
      k2_cN : char = ^N;       { Realnameanzeige      }
      k2_BB : char = '#';      { Kommentarbaum        }
      k2_A  : char = 'A';      { unversandt <-> Alle  }
      k2_b  : char = 'b';      { Brettbrief           }
      k2_cB : char = ^B;       { Quote-Brettbrief     }
      k2_SB : char = 'B';      { Multiquote           }
      k2_p  : char = 'p';      { PM                   }
      k2_cP : char = ^P;       { Quote-PM             }
      k2_SP : char = 'P';      { Multiquote-PM        }
      k2_cT : char = ^T;       { User-Pawort-Edit    }
      k2_cQ : char = ^Q;       { indirekter Fido-Quote}
      k2_M  : char = 'M';      { MessageID-Request    }

      k3_H  : char = 'H';      { neuer AV-Eintrag     }
      k3_E  : char = 'E';      { AutoVersand Edit     }
      k3_L  : char = 'L';      { lschen              }
      k3_A  : char = 'A';      { aktiv                }
      k3_T  : char = 'T';      { TextEdit             }
      k3_I  : char = 'I';      { Fileinfo             }
      k3_S  : char = 'S';      { Autoversand Senden   }
      k3_K  : char = 'K';      { Eintrag kopieren     }

      k4_D  : char = 'D';      { Drucken im Lister    }
      k4_W  : char = 'W';      { in Datei schreiben   }
      k4_L  : char = 'L';      { Nachricht lschen    }
      k4_cL : char = ^L;       { .. und drinbleiben   }
      k4_H  : char = 'H';      { Nachricht halten     }
      k4_F  : char = 'F';      { Farbumschaltung      }


implementation  { -------------------------------------------------- }

uses xp4o,xpnetcall,xpconfigedit,xpauto, clip, maske;


{ Funktionstaste in Hauptfenster oder ArcViewer }

procedure prog_call(nr,nn: integer);
var s,s1   : string;
    p0, p1, x, y: integer;
    fn,fn2 : string;
    brk    : boolean;
    auto   : boolean;
begin
  with fkeys[nr][nn] do begin
    s:=prog;
    auto:=autoexec;
    if FirstChar(s) = '*' then
    begin
      if funcexternal then exit;
      s:=UpperCase(trim(s));
      if copy(s,2,7)='NETCALL' then
        EinzelNetcall(trim(copy(s,10,BoxNameLen)))
      else if copy(s,2,8)='RNETCALL' then
        netcall(true,trim(copy(s,11,BoxNameLen)),false,true,false)
      else if mid(s,2)='REORG' then begin
        MsgReorgScan(true,false,brk);
        if not brk then MsgReorg;
        end
      else if copy(s,2,7)='SETUSER' then
        SetUsername(mid(trim(prog),10))    { in XPConfigEdit }
      else if copy(s,2,4)='LIST' then begin
        fn:=trim(mid(s,7));
        if FileExists(fn) then
          repeat until listfile(fn,fn,true,false,false, 0) <> -4
        else
          rfehler(20);   { '*LIST: Datei nicht vorhanden!' }
        end
      else if copy(s,2,4)='EDIT' then begin
        fn:=trim(mid(s,7));
        if FileExists(fn) then
          EditFile(fn,false,false,false,0,false)
        else
          rfehler(23)    { '*EDIT: Datei nicht vorhanden!' }
        end
      else if mid(s,2)='AUTOEXEC' then
        auto:=true
      else if s<>'*' then
        rfehler1(21,LeftStr(s,50));   { 'Ungltige Funktion:  %s' }
      end
    else if s<>'' then
    begin
      p0:=pos('$FILE',UpperCase(s));
      if p0>0 then begin
        fn:=getfilename(nr,nn);
        if (fn='') or not FileExists(fn) then exit;
        s:= LeftStr(s, p0-1) + fn + Mid(s, p0+5);
      end;

      p1 := Pos('$CLIP', UpperCase(s));
      if p1 > 0 then
        s:= LeftStr(s, p1-1) + Clip2String + Mid(s, p1+5);

      p1 := pos('$ASK', UpperCase(s));
      if p1>0 then
      begin
        x:=15; y:=11; s1:='';
        pushhp(449);
        dialog(length(getres(151))+47,3,'"'+
          iifs(s> LeftStr(s,length(getres(151))+47-6),
              LeftStr(s,length(getres(151))+47-9)+'...',s)+'"',x,y);
        maddstring(3,2,getres(151),s1,40,
          127-(p1-1+max(length(mid(s,p1+4)),0)),'');
        readmask(brk);
        enddialog;
        pophp;
        if brk then
          exit
        else
          s:= LeftStr(s,p1-1)+trim(s1+mid(s,p1+4));
      end;

      if @preextproc<>nil then begin
        preextproc;
        preextproc:=nil;
        end;
      shellkey:=warten;
      if listout then begin
        fn2:=TempFile(TempPath);
        shell(s+'>'+fn2,speicher,0);
        if listfile(fn2,'',true,false,false,0)<>0 then;
        if FileExists(fn2) then DeleteFile(fn2);
        end
      else
        shell(s,speicher,iif(vollbild,1,3));
      if (p0>0) and not bname and (FileExists(fn)) then
        DeleteFile(fn);
      end;
    if auto then
      if (s='') and isEmptyDir(AutoxDir) then
        hinweis(getres(150))   { 'keine Dateien im AUTOEXEC-Verzeichnis vorhanden' }
      else
        xpauto.AutoExec(false);
    end;
end;

function test_fkeys(var t:taste):boolean;
var nr,n : shortint;
begin
  test_fkeys:=false;
  nr:=0;
  if (t>=keysf1) and (t<=keysf10) then nr:=1
  else if (t>=keycf1) and (t<=keycf10) then nr:=2
  else if (t>=keyaf1) and (t<=keyaf10) then nr:=3;
  if nr>0 then begin
    n:=(ord(t[2])-84)mod 10+1;
    if fkeys[nr][n].prog<>'' then begin
      prog_call(nr,n);
      test_fkeys:=true;
      end;
    end;
end;


{ flags:  1 = Bretter, 2 = User, 4 = Msgs, 8=Lister, 16=ArcViewer, 32=Editor,
          64 = Terminal }

procedure Xmakro(var t:taste; flags:byte);
var i : integer;
    s : string;
begin
  i:=1;
  while (i<=keymacros) and ((macroflags[i] and flags=0) or (t<>macrokey[i])) do
    inc(i);
  if i<=keymacros then begin
    s:=macrodef[i];
    if s[1]=#0 then t:=LeftStr(s,2)
    else t:=s[1];
    insert(mid(s,length(t)+1),forwardkeys,1);
    end;
end;

end.
